/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.support.identification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ArchetypeID
extends ObjectId {
    @Nullable
    private String namespace;
    @Nullable
    private String qualifiedRmEntity;
    @Nullable
    private String domainConcept;
    @Nullable
    private String rmOriginator;
    @Nullable
    private String rmName;
    @Nullable
    private String rmEntity;
    @Nullable
    private String specialisation;
    @Nullable
    private String versionId;
    private static final Pattern archetypeIDPattern = Pattern.compile("((?<namespace>.*)::)?(?<publisher>[^.-]*)-(?<package>[^.-]*)-(?<class>[^.-]*)\\.(?<concept>[^.]*)(-(?<specialisation>[^.]*))?(\\.v(?<version>.*))?");

    public ArchetypeID() {
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public ArchetypeID(String value) {
        this.parseValue(value);
        this.setValue(value);
    }

    private void parseValue(String value) {
        Matcher m = archetypeIDPattern.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException(value + " is not a valid archetype human readable id");
        }
        this.namespace = m.group("namespace");
        this.rmOriginator = m.group("publisher");
        this.rmName = m.group("package");
        this.rmEntity = m.group("class");
        this.buildQualifiedRmEntity();
        this.specialisation = m.group("specialisation");
        this.domainConcept = m.group("concept");
        this.versionId = m.group("version");
    }

    public void buildQualifiedRmEntity() {
        this.qualifiedRmEntity = this.rmOriginator + "-" + this.rmName + "-" + this.rmEntity;
    }

    @JsonCreator
    public ArchetypeID(@JsonProperty(value="qualified_rm_entity") String qualifiedRmEntity, @JsonProperty(value="domain_concept") String domainConcept, @JsonProperty(value="rm_originator") String rmOriginator, @JsonProperty(value="rm_name") String rmName, @JsonProperty(value="rm_entity") String rmEntity, @JsonProperty(value="specialisation") String specialisation, @JsonProperty(value="versionId") String versionId, @JsonProperty(value="value") String value) {
        if (value != null) {
            this.parseValue(value);
            this.setValue(value);
        } else {
            this.qualifiedRmEntity = qualifiedRmEntity;
            this.domainConcept = domainConcept;
            this.rmOriginator = rmOriginator;
            this.rmName = rmName;
            this.rmEntity = rmEntity;
            this.specialisation = specialisation;
            this.versionId = versionId;
            this.setValue(this.getFullId());
        }
    }

    @RMPropertyIgnore
    public String getFullId() {
        StringBuilder result = new StringBuilder(30);
        if (this.namespace != null) {
            result.append(this.namespace);
            result.append("::");
        }
        result.append(this.rmOriginator);
        result.append("-");
        result.append(this.rmName);
        result.append("-");
        result.append(this.rmEntity);
        result.append(".");
        result.append(this.domainConcept);
        if (this.specialisation != null) {
            result.append("-");
            result.append(this.specialisation);
        }
        if (this.versionId == null) {
            return result.toString();
        }
        if (this.versionId.startsWith("v")) {
            result.append(".");
        } else {
            result.append(".v");
        }
        result.append(this.versionId);
        return result.toString();
    }

    @RMPropertyIgnore
    public String getSemanticId() {
        StringBuilder result = new StringBuilder();
        if (this.namespace != null) {
            result.append(this.namespace);
            result.append("::");
        }
        result.append(this.rmOriginator);
        result.append("-");
        result.append(this.rmName);
        result.append("-");
        result.append(this.rmEntity);
        result.append(".");
        result.append(this.domainConcept);
        if (this.versionId == null) {
            return result.toString();
        }
        if (this.versionId.startsWith("v")) {
            result.append(".");
        } else {
            result.append(".v");
        }
        result.append(this.versionId.split("\\.")[0]);
        return result.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getQualifiedRmEntity() {
        return this.qualifiedRmEntity;
    }

    public void setQualifiedRmEntity(String qualifiedRmEntity) {
        this.qualifiedRmEntity = qualifiedRmEntity;
    }

    public String getDomainConcept() {
        return this.domainConcept;
    }

    public void setDomainConcept(String domainConcept) {
        this.domainConcept = domainConcept;
    }

    public String getRmOriginator() {
        return this.rmOriginator;
    }

    public void setRmOriginator(String rmOriginator) {
        this.rmOriginator = rmOriginator;
    }

    public String getRmName() {
        return this.rmName;
    }

    public void setRmName(String rmName) {
        this.rmName = rmName;
    }

    public String getRmEntity() {
        return this.rmEntity;
    }

    public void setRmEntity(String rmEntity) {
        this.rmEntity = rmEntity;
    }

    public String getSpecialisation() {
        return this.specialisation;
    }

    public void setSpecialisation(String specialisation) {
        this.specialisation = specialisation;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public String toString() {
        return this.getFullId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArchetypeID that = (ArchetypeID)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.qualifiedRmEntity, that.qualifiedRmEntity) && Objects.equals(this.domainConcept, that.domainConcept) && Objects.equals(this.rmOriginator, that.rmOriginator) && Objects.equals(this.rmName, that.rmName) && Objects.equals(this.rmEntity, that.rmEntity) && Objects.equals(this.specialisation, that.specialisation) && Objects.equals(this.versionId, that.versionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.namespace, this.qualifiedRmEntity, this.domainConcept, this.rmOriginator, this.rmName, this.rmEntity, this.specialisation, this.versionId);
    }
}

