/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity.datetime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.json.DateTimeDeserializer;
import com.nedap.archie.json.DateTimeSerializer;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import com.nedap.archie.xml.adapters.DateTimeXmlAdapter;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_DATE_TIME", propOrder={"value"})
public class DvDateTime
extends DvTemporal<Long>
implements SingleValuedDataValue<TemporalAccessor> {
    @XmlJavaTypeAdapter(value=DateTimeXmlAdapter.class)
    private TemporalAccessor value;

    public DvDateTime() {
    }

    public DvDateTime(TemporalAccessor value) {
        this.value = value;
    }

    public DvDateTime(String iso8601DateTime) {
        this.value = DateTimeParsers.parseDateTimeValue((String)iso8601DateTime);
    }

    public DvDateTime(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, @Nullable CodePhrase normalStatus, @Nullable String magnitudeStatus, @Nullable DvDuration accuracy, TemporalAccessor value) {
        super(otherReferenceRanges, normalRange, normalStatus, magnitudeStatus, accuracy);
        this.value = value;
    }

    @Override
    @JsonSerialize(using=DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeDeserializer.class)
    public TemporalAccessor getValue() {
        return this.value;
    }

    @Override
    public void setValue(TemporalAccessor value) {
        this.value = value;
    }

    @Override
    @XmlTransient
    @JsonIgnore
    public Long getMagnitude() {
        if (this.value == null) {
            return null;
        }
        if (this.value.query(TemporalQueries.zone()) != null) {
            return ZonedDateTime.from(this.value).toEpochSecond();
        }
        return LocalDateTime.from(this.value).toEpochSecond(ZoneOffset.UTC);
    }

    public void setMagnitude(Long magnitude) {
        this.value = magnitude == null ? null : LocalDateTime.ofEpochSecond(magnitude, 0, ZoneOffset.UTC);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvDateTime that = (DvDateTime)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

