/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity;

import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.DvOrdered;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_SCALE", propOrder={"value", "symbol"})
public class DvScale
extends DvOrdered<DvScale>
implements SingleValuedDataValue<Double>,
Comparable<DvScale> {
    private DvCodedText symbol;
    private Double value;

    public DvScale() {
    }

    public DvScale(Double value, DvCodedText symbol) {
        this.symbol = symbol;
        this.value = value;
    }

    public DvScale(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, Double value, DvCodedText symbol) {
        super(otherReferenceRanges, normalRange);
        this.symbol = symbol;
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public int compareTo(DvScale o) {
        return this.value.compareTo(o.value);
    }

    public DvCodedText getSymbol() {
        return this.symbol;
    }

    public void setSymbol(DvCodedText symbol) {
        this.symbol = symbol;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvScale dvScale = (DvScale)o;
        return Objects.equals(this.symbol, dvScale.symbol) && Objects.equals(this.value, dvScale.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.symbol, this.value);
    }
}

