/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.quantity.DvAmount;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_PROPORTION", propOrder={"numerator", "denominator", "type", "precision"})
public class DvProportion
extends DvAmount<Double> {
    private Double numerator;
    private Double denominator;
    private Long type;
    @Nullable
    private Long precision;

    public DvProportion() {
    }

    public DvProportion(Double numerator, Double denominator, Long type) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.type = type;
    }

    public DvProportion(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, @Nullable CodePhrase normalStatus, @Nullable Double accuracy, @Nullable Boolean accuracyIsPercent, @Nullable String magnitudeStatus, Double numerator, Double denominator, Long type, @Nullable Long precision) {
        super(otherReferenceRanges, normalRange, normalStatus, accuracy, accuracyIsPercent, magnitudeStatus);
        this.numerator = numerator;
        this.denominator = denominator;
        this.type = type;
        this.precision = precision;
    }

    public Double getNumerator() {
        return this.numerator;
    }

    public void setNumerator(Double numerator) {
        this.numerator = numerator;
    }

    public Double getDenominator() {
        return this.denominator;
    }

    public void setDenominator(Double denominator) {
        this.denominator = denominator;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    @Nullable
    public Long getPrecision() {
        return this.precision;
    }

    public void setPrecision(@Nullable Long precision) {
        this.precision = precision;
    }

    @JsonIgnore
    public boolean isIntegral() {
        return this.precision != null && this.precision == 0L;
    }

    @Override
    @JsonIgnore
    public Double getMagnitude() {
        if (this.numerator != null && this.denominator != null && this.denominator != 0.0) {
            return this.numerator / this.denominator;
        }
        if (this.numerator == null) {
            return 0.0;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvProportion that = (DvProportion)o;
        return Objects.equals(this.numerator, that.numerator) && Objects.equals(this.denominator, that.denominator) && Objects.equals(this.type, that.type) && Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numerator, this.denominator, this.type, this.precision);
    }
}

