/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datatypes;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CODE_PHRASE", propOrder={"terminologyId", "codeString", "preferredTerm"})
public class CodePhrase
extends RMObject {
    @XmlElement(name="terminology_id")
    private TerminologyId terminologyId;
    @XmlElement(name="code_string")
    private String codeString;
    @Nullable
    @XmlElement(name="preferred_term")
    private String preferredTerm;

    public CodePhrase() {
    }

    public CodePhrase(TerminologyId terminologyId, String codeString) {
        this(terminologyId, codeString, null);
    }

    public CodePhrase(TerminologyId terminologyId, String codeString, String preferredTerm) {
        this.terminologyId = terminologyId;
        this.codeString = codeString;
        this.preferredTerm = preferredTerm;
    }

    public CodePhrase(String phrase) {
        Pattern pattern = Pattern.compile("\\[?(?<terminologyId>.+)(\\((?<terminologyVersion>.+)\\))?::(?<codeString>[^\\]]+)\\]?");
        Matcher matcher = pattern.matcher(phrase);
        if (matcher.matches()) {
            this.terminologyId = new TerminologyId(matcher.group("terminologyId"), matcher.group("terminologyVersion"));
            this.codeString = matcher.group("codeString");
        } else {
            this.terminologyId = new TerminologyId();
            this.terminologyId.setValue("UNKNOWN");
            this.codeString = phrase;
        }
    }

    public TerminologyId getTerminologyId() {
        return this.terminologyId;
    }

    public void setTerminologyId(TerminologyId terminologyId) {
        this.terminologyId = terminologyId;
    }

    public String getCodeString() {
        return this.codeString;
    }

    public void setCodeString(String codeString) {
        this.codeString = codeString;
    }

    public String getPreferredTerm() {
        return this.preferredTerm;
    }

    public void setPreferredTerm(String preferredTerm) {
        this.preferredTerm = preferredTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodePhrase that = (CodePhrase)o;
        return Objects.equals(this.terminologyId, that.terminologyId) && Objects.equals(this.codeString, that.codeString) && Objects.equals(this.preferredTerm, that.preferredTerm);
    }

    public int hashCode() {
        return Objects.hash(this.terminologyId, this.codeString, this.preferredTerm);
    }

    public String toString() {
        return this.terminologyId + "::" + this.codeString;
    }
}

