/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.archetyped;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.paths.PathUtil;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.query.RMPathQuery;
import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PATHABLE")
public abstract class Pathable
extends RMObject {
    @JsonIgnore
    @XmlTransient
    @Nullable
    private Pathable parent;
    @JsonIgnore
    @XmlTransient
    @Nullable
    private String parentAttributeName;

    public Pathable() {
    }

    public Pathable(@Nullable Pathable parent, @Nullable String parentAttributeName) {
        this.parent = parent;
        this.parentAttributeName = parentAttributeName;
    }

    public Object itemAtPath(String s) {
        return new RMPathQuery(s).find((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), (Object)this);
    }

    public List<Object> itemsAtPath(String s) {
        List objects = new RMPathQuery(s).findList((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), (Object)this);
        ArrayList<Object> result = new ArrayList<Object>();
        for (RMObjectWithPath object : objects) {
            result.add(object.getObject());
        }
        return result;
    }

    @JsonIgnore
    public Pathable getParent() {
        return this.parent;
    }

    private void setParent(Pathable parent) {
        this.parent = parent;
    }

    private void setParentAttributeName(String parentAttributeName) {
        this.parentAttributeName = parentAttributeName;
    }

    protected void setThisAsParent(Pathable child, String attributeName) {
        if (child != null) {
            child.setParent(this);
            child.setParentAttributeName(attributeName);
        }
    }

    protected void setThisAsParent(Collection<? extends Pathable> children, String attributeName) {
        if (children != null) {
            for (Pathable pathable : children) {
                this.setThisAsParent(pathable, attributeName);
            }
        }
    }

    protected String getParentAttributeName() {
        return this.parentAttributeName;
    }

    @RMPropertyIgnore
    public List<PathSegment> getPathSegments() {
        Pathable parent = this.getParent();
        if (parent == null) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> segments = parent.getPathSegments();
        segments.add(new PathSegment(this.parentAttributeName));
        return segments;
    }

    @RMPropertyIgnore
    public final String getPath() {
        return PathUtil.getPath(this.getPathSegments());
    }
}

