/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.archetyped;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LOCATABLE", propOrder={"name", "uid", "links", "archetypeDetails", "feederAudit"})
public abstract class Locatable
extends Pathable {
    @XmlElement
    private DvText name;
    @XmlAttribute(name="archetype_node_id")
    private String archetypeNodeId;
    @Nullable
    private UIDBasedId uid;
    @XmlElement(name="archetype_details")
    @Nullable
    private Archetyped archetypeDetails;
    @XmlElement(name="feeder_audit")
    @Nullable
    private FeederAudit feederAudit;
    @Nullable
    private List<Link> links = new ArrayList<Link>();

    public Locatable() {
    }

    public Locatable(String archetypeNodeId, DvText name) {
        this.name = name;
        this.archetypeNodeId = archetypeNodeId;
    }

    public Locatable(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName) {
        super(parent, parentAttributeName);
        this.name = name;
        this.archetypeNodeId = archetypeNodeId;
        this.uid = uid;
        this.archetypeDetails = archetypeDetails;
        this.feederAudit = feederAudit;
        this.links = links;
    }

    public DvText getName() {
        return this.name;
    }

    public void setName(DvText name) {
        this.name = name;
    }

    public void setNameAsString(String name) {
        this.name = new DvText(name);
    }

    public String getArchetypeNodeId() {
        return this.archetypeNodeId;
    }

    public void setArchetypeNodeId(String archetypeNodeId) {
        this.archetypeNodeId = archetypeNodeId;
    }

    public UIDBasedId getUid() {
        return this.uid;
    }

    public void setUid(UIDBasedId uid) {
        this.uid = uid;
    }

    public Archetyped getArchetypeDetails() {
        return this.archetypeDetails;
    }

    public void setArchetypeDetails(Archetyped archetypeDetails) {
        this.archetypeDetails = archetypeDetails;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> linked) {
        this.links = linked;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    @Override
    @JsonIgnore
    @RMPropertyIgnore
    public List<PathSegment> getPathSegments() {
        Pathable parent = this.getParent();
        if (parent == null) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> segments = parent.getPathSegments();
        segments.add(new PathSegment(this.getParentAttributeName(), this.archetypeNodeId));
        return segments;
    }

    @JsonIgnore
    @RMPropertyIgnore
    public String getNameAsString() {
        return this.name == null ? null : this.name.getValue();
    }

    @Nullable
    public FeederAudit getFeederAudit() {
        return this.feederAudit;
    }

    public void setFeederAudit(@Nullable FeederAudit feederAudit) {
        this.feederAudit = feederAudit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Locatable locatable = (Locatable)o;
        return Objects.equals(this.name, locatable.name) && Objects.equals(this.archetypeNodeId, locatable.archetypeNodeId) && Objects.equals(this.uid, locatable.uid) && Objects.equals(this.archetypeDetails, locatable.archetypeDetails) && Objects.equals(this.feederAudit, locatable.feederAudit) && Objects.equals(this.links, locatable.links);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.archetypeNodeId, this.uid, this.archetypeDetails, this.feederAudit, this.links);
    }
}

