/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.ehr;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="EHR")
@XmlType(name="EHR", propOrder={"systemId", "ehrId", "timeCreated", "contributions", "ehrAccess", "ehrStatus", "directory", "compositions"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Ehr
extends RMObject {
    @XmlElement(name="system_id")
    private HierObjectId systemId;
    @XmlElement(name="ehr_id")
    private HierObjectId ehrId;
    private List<ObjectRef> contributions = new ArrayList<ObjectRef>();
    @XmlElement(name="ehr_status")
    private ObjectRef ehrStatus;
    @XmlElement(name="ehr_access")
    private ObjectRef ehrAccess;
    @Nullable
    private List<ObjectRef> compositions = new ArrayList<ObjectRef>();
    @Nullable
    private ObjectRef directory;
    @XmlElement(name="time_created")
    private DvDateTime timeCreated;

    public Ehr() {
    }

    public Ehr(HierObjectId systemId, HierObjectId ehrId, DvDateTime timeCreated, List<ObjectRef> contributions, ObjectRef ehrStatus, ObjectRef ehrAccess, @Nullable ObjectRef directory, @Nullable List<ObjectRef> compositions) {
        this.systemId = systemId;
        this.ehrId = ehrId;
        this.contributions = contributions;
        this.ehrStatus = ehrStatus;
        this.ehrAccess = ehrAccess;
        this.compositions = compositions;
        this.directory = directory;
        this.timeCreated = timeCreated;
    }

    public HierObjectId getSystemId() {
        return this.systemId;
    }

    public void setSystemId(HierObjectId systemId) {
        this.systemId = systemId;
    }

    public HierObjectId getEhrId() {
        return this.ehrId;
    }

    public void setEhrId(HierObjectId ehrId) {
        this.ehrId = ehrId;
    }

    @Nullable
    public List<ObjectRef> getContributions() {
        return this.contributions;
    }

    public void setContributions(@Nullable List<ObjectRef> contributions) {
        this.contributions = contributions;
    }

    public void addContribution(ObjectRef contribution) {
        this.contributions.add(contribution);
    }

    public ObjectRef getEhrStatus() {
        return this.ehrStatus;
    }

    public void setEhrStatus(ObjectRef ehrStatus) {
        this.ehrStatus = ehrStatus;
    }

    public ObjectRef getEhrAccess() {
        return this.ehrAccess;
    }

    public void setEhrAccess(ObjectRef ehrAccess) {
        this.ehrAccess = ehrAccess;
    }

    @Nullable
    public List<ObjectRef> getCompositions() {
        return this.compositions;
    }

    public void setCompositions(@Nullable List<ObjectRef> compositions) {
        this.compositions = compositions;
    }

    public void addComposition(ObjectRef composition) {
        this.compositions.add(composition);
    }

    @Nullable
    public ObjectRef getDirectory() {
        return this.directory;
    }

    public void setDirectory(@Nullable ObjectRef directory) {
        this.directory = directory;
    }

    public DvDateTime getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(DvDateTime timeCreated) {
        this.timeCreated = timeCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ehr ehr = (Ehr)o;
        return Objects.equals(this.systemId, ehr.systemId) && Objects.equals(this.ehrId, ehr.ehrId) && Objects.equals(this.contributions, ehr.contributions) && Objects.equals(this.ehrStatus, ehr.ehrStatus) && Objects.equals(this.ehrAccess, ehr.ehrAccess) && Objects.equals(this.compositions, ehr.compositions) && Objects.equals(this.directory, ehr.directory) && Objects.equals(this.timeCreated, ehr.timeCreated);
    }

    public int hashCode() {
        return Objects.hash(this.systemId, this.ehrId, this.contributions, this.ehrStatus, this.ehrAccess, this.compositions, this.directory, this.timeCreated);
    }
}

