/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity.datetime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.json.TimeDeserializer;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import com.nedap.archie.xml.adapters.TimeXmlAdapter;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_TIME", propOrder={"value"})
public class DvTime
extends DvTemporal<Double>
implements SingleValuedDataValue<TemporalAccessor> {
    @XmlJavaTypeAdapter(value=TimeXmlAdapter.class)
    private TemporalAccessor value;

    public DvTime() {
    }

    public DvTime(TemporalAccessor value) {
        this.value = value;
    }

    public DvTime(String iso8601Time) {
        this.value = DateTimeParsers.parseTimeValue((String)iso8601Time);
    }

    public DvTime(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, @Nullable CodePhrase normalStatus, @Nullable String magnitudeStatus, @Nullable DvDuration accuracy, TemporalAccessor value) {
        super(otherReferenceRanges, normalRange, normalStatus, magnitudeStatus, accuracy);
        this.value = value;
    }

    @Override
    public void setValue(TemporalAccessor value) {
        this.value = value;
    }

    @Override
    @JsonDeserialize(using=TimeDeserializer.class)
    public TemporalAccessor getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    @XmlTransient
    public Double getMagnitude() {
        return this.value == null ? null : Double.valueOf(LocalTime.from(this.value).toSecondOfDay());
    }

    public void setMagnitude(Double magnitude) {
        this.value = magnitude == null ? null : LocalTime.ofSecondOfDay(Math.round(magnitude));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvTime dvTime = (DvTime)o;
        return Objects.equals(this.value, dvTime.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

