/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity.datetime;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.nedap.archie.datetime.DateTimeParsers;
import com.nedap.archie.json.DateDeserializer;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvTemporal;
import com.nedap.archie.xml.adapters.DateXmlAdapter;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_DATE", propOrder={"value"})
public class DvDate
extends DvTemporal<Long>
implements SingleValuedDataValue<Temporal> {
    @XmlJavaTypeAdapter(value=DateXmlAdapter.class)
    private Temporal value;

    public DvDate() {
    }

    public DvDate(Temporal value) {
        this.setValue(value);
    }

    public DvDate(String iso8601Date) {
        this.setValue(DateTimeParsers.parseDateValue((String)iso8601Date));
    }

    public DvDate(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, @Nullable CodePhrase normalStatus, @Nullable String magnitudeStatus, @Nullable DvDuration accuracy, Temporal value) {
        super(otherReferenceRanges, normalRange, normalStatus, magnitudeStatus, accuracy);
        this.value = value;
    }

    @Override
    @JsonDeserialize(using=DateDeserializer.class)
    public Temporal getValue() {
        return this.value;
    }

    @Override
    public void setValue(Temporal value) {
        if (value.isSupported(ChronoField.HOUR_OF_DAY)) {
            throw new IllegalArgumentException("value must only have a year, month or date, but this supports hours: " + value);
        }
        this.value = value;
    }

    @Override
    @JsonIgnore
    @XmlTransient
    public Long getMagnitude() {
        return this.value == null ? null : Long.valueOf(LocalDate.from(this.value).toEpochDay());
    }

    public void setMagnitude(Long magnitude) {
        this.value = magnitude == null ? null : LocalDate.ofEpochDay(magnitude);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DvDate dvDate = (DvDate)o;
        return Objects.equals(this.value, dvDate.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

