/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datavalues.quantity;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.quantity.DvInterval;
import com.nedap.archie.rm.datavalues.quantity.ReferenceRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DV_ORDERED", propOrder={"normalRange", "otherReferenceRanges", "normalStatus"})
public abstract class DvOrdered<ComparableType>
extends DataValue
implements Comparable<ComparableType> {
    @Nullable
    @XmlElement(name="normal_status")
    private CodePhrase normalStatus;
    @Nullable
    @XmlElement(name="normal_range")
    private DvInterval normalRange;
    @Nullable
    @XmlElement(name="other_reference_ranges")
    private List<ReferenceRange> otherReferenceRanges = new ArrayList<ReferenceRange>();

    public DvOrdered() {
    }

    public DvOrdered(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange) {
        this.normalRange = normalRange;
        this.otherReferenceRanges = otherReferenceRanges;
    }

    protected DvOrdered(@Nullable List<ReferenceRange> otherReferenceRanges, @Nullable DvInterval normalRange, @Nullable CodePhrase normalStatus) {
        this.normalStatus = normalStatus;
        this.normalRange = normalRange;
        this.otherReferenceRanges = otherReferenceRanges;
    }

    public DvInterval getNormalRange() {
        return this.normalRange;
    }

    public void setNormalRange(DvInterval normalRange) {
        this.normalRange = normalRange;
    }

    public List<ReferenceRange> getOtherReferenceRanges() {
        return this.otherReferenceRanges;
    }

    public void setOtherReferenceRanges(List<ReferenceRange> otherReferenceRanges) {
        this.otherReferenceRanges = otherReferenceRanges;
    }

    public void addOtherReferenceRange(ReferenceRange range) {
        this.otherReferenceRanges.add(range);
    }

    @Nullable
    public CodePhrase getNormalStatus() {
        return this.normalStatus;
    }

    public void setNormalStatus(@Nullable CodePhrase normalStatus) {
        this.normalStatus = normalStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DvOrdered dvOrdered = (DvOrdered)o;
        return Objects.equals(this.normalStatus, dvOrdered.normalStatus) && Objects.equals(this.normalRange, dvOrdered.normalRange) && Objects.equals(this.otherReferenceRanges, dvOrdered.otherReferenceRanges);
    }

    public int hashCode() {
        return Objects.hash(this.normalStatus, this.normalRange, this.otherReferenceRanges);
    }
}

