/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datastructures;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Element;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ITEM_LIST", propOrder={"items"})
@XmlRootElement(name="item_list")
public class ItemList
extends ItemStructure<Element> {
    @Nullable
    private List<Element> items = new ArrayList<Element>();

    public ItemList() {
    }

    public ItemList(String archetypeNodeId, DvText name, @Nullable List<Element> items) {
        super(archetypeNodeId, name);
        this.setItems(items);
    }

    public ItemList(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, @Nullable List<Element> items) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.setItems(items);
    }

    @Override
    public List<Element> getItems() {
        return this.items;
    }

    public void setItems(List<Element> items) {
        this.items = items;
        this.setThisAsParent(items, "items");
    }

    public void addItem(Element item) {
        this.items.add(item);
        this.setThisAsParent(item, "items");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItemList itemList = (ItemList)o;
        return Objects.equals(this.items, itemList.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items);
    }
}

