/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datastructures;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.DataStructure;
import com.nedap.archie.rm.datastructures.Event;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDuration;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="HISTORY", propOrder={"origin", "period", "duration", "events", "summary"})
public final class History<Type extends ItemStructure>
extends DataStructure {
    private DvDateTime origin;
    @Nullable
    private DvDuration period;
    @Nullable
    private DvDuration duration;
    @Nullable
    private Type summary;
    @Nullable
    private List<Event<Type>> events = new ArrayList<Event<Type>>();

    public History() {
    }

    public History(String archetypeNodeId, DvText name, DvDateTime origin, @Nullable List<Event<Type>> events) {
        super(archetypeNodeId, name);
        this.origin = origin;
        this.events = events;
    }

    public History(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, DvDateTime origin, @Nullable List<Event<Type>> events, @Nullable DvDuration period, @Nullable DvDuration duration, @Nullable Type summary) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.origin = origin;
        this.period = period;
        this.duration = duration;
        this.summary = summary;
        this.events = events;
    }

    public DvDateTime getOrigin() {
        return this.origin;
    }

    public void setOrigin(DvDateTime origin) {
        this.origin = origin;
    }

    @Nullable
    public DvDuration getPeriod() {
        return this.period;
    }

    public void setPeriod(@Nullable DvDuration period) {
        this.period = period;
    }

    @Nullable
    public DvDuration getDuration() {
        return this.duration;
    }

    public void setDuration(@Nullable DvDuration duration) {
        this.duration = duration;
    }

    public List<Event<Type>> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event<Type>> events) {
        this.events = events;
        this.setThisAsParent(events, "events");
    }

    public void addEvent(Event<Type> event) {
        this.events.add(event);
        this.setThisAsParent(event, "events");
    }

    @Nullable
    public Type getSummary() {
        return this.summary;
    }

    public void setSummary(@Nullable Type summary) {
        this.summary = summary;
        this.setThisAsParent((Pathable)summary, "summary");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        History history = (History)o;
        return Objects.equals(this.origin, history.origin) && Objects.equals(this.period, history.period) && Objects.equals(this.duration, history.duration) && Objects.equals(this.summary, history.summary) && Objects.equals(this.events, history.events);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.origin, this.period, this.duration, this.summary, this.events);
    }
}

