/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datastructures;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CLUSTER", propOrder={"items"})
@XmlRootElement
public class Cluster<Type extends Item>
extends Item {
    private List<Type> items = new ArrayList<Type>();

    public Cluster() {
    }

    public Cluster(String archetypeNodeId, DvText name, List<Type> items) {
        super(archetypeNodeId, name);
        this.setItems(items);
    }

    public Cluster(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, List<Type> items) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.setItems(items);
    }

    public List<Type> getItems() {
        return this.items;
    }

    public void setItems(List<Type> items) {
        this.items = items;
        this.setThisAsParent(items, "items");
    }

    public void addItem(Type item) {
        this.items.add(item);
        this.setThisAsParent((Pathable)item, "items");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return Objects.equals(this.items, cluster.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items);
    }
}

