/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.composition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Locatable;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.composition.EventContext;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="COMPOSITION", propOrder={"language", "territory", "category", "composer", "context", "content"})
@XmlRootElement(name="composition")
public class Composition
extends Locatable {
    private CodePhrase language;
    private CodePhrase territory;
    private DvCodedText category;
    private PartyProxy composer;
    @Nullable
    private EventContext context;
    @Nullable
    private List<ContentItem> content = new ArrayList<ContentItem>();

    public Composition() {
    }

    public Composition(String archetypeNodeId, DvText name, @Nullable List<ContentItem> content, CodePhrase language, @Nullable EventContext context, PartyProxy composer, DvCodedText category, CodePhrase territory) {
        super(archetypeNodeId, name);
        this.language = language;
        this.territory = territory;
        this.category = category;
        this.composer = composer;
        this.context = context;
        this.content = content;
    }

    public Composition(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, @Nullable List<ContentItem> content, CodePhrase language, @Nullable EventContext context, PartyProxy composer, DvCodedText category, CodePhrase territory) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.language = language;
        this.territory = territory;
        this.category = category;
        this.composer = composer;
        this.context = context;
        this.content = content;
    }

    @JsonProperty
    public CodePhrase getLanguage() {
        return this.language;
    }

    @JsonProperty
    public void setLanguage(CodePhrase language) {
        this.language = language;
    }

    @JsonIgnore
    public void setLanguage(String codePhrase) {
        this.language = new CodePhrase(codePhrase);
    }

    @JsonProperty
    public CodePhrase getTerritory() {
        return this.territory;
    }

    @JsonProperty
    public void setTerritory(CodePhrase territory) {
        this.territory = territory;
    }

    @JsonIgnore
    public void setTerritory(String codePhrase) {
        this.territory = new CodePhrase(codePhrase);
    }

    @JsonProperty
    public DvCodedText getCategory() {
        return this.category;
    }

    @JsonProperty
    public void setCategory(DvCodedText category) {
        this.category = category;
    }

    @JsonIgnore
    public void setCategory(String codePhrase) {
        this.category = new DvCodedText();
        this.category.setDefiningCode(new CodePhrase(codePhrase));
    }

    public PartyProxy getComposer() {
        return this.composer;
    }

    public void setComposer(PartyProxy composer) {
        this.composer = composer;
    }

    @Nullable
    public EventContext getContext() {
        return this.context;
    }

    public void setContext(@Nullable EventContext context) {
        this.context = context;
        this.setThisAsParent(context, "context");
    }

    public List<ContentItem> getContent() {
        return this.content;
    }

    public void setContent(List<ContentItem> content) {
        this.content = content;
        this.setThisAsParent(content, "content");
    }

    public void addContent(ContentItem item) {
        this.content.add(item);
        this.setThisAsParent(item, "content");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Composition that = (Composition)o;
        return Objects.equals(this.language, that.language) && Objects.equals(this.territory, that.territory) && Objects.equals(this.category, that.category) && Objects.equals(this.composer, that.composer) && Objects.equals(this.context, that.context) && Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language, this.territory, this.category, this.composer, this.context, this.content);
    }
}

