/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.openehr.odin.jackson.ODINGenerator;
import org.openehr.odin.jackson.PackageVersion;

public class ODINFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_ODIN = "ODIN";
    protected static final int DEFAULT_ODIN_GENERATOR_FEATURE_FLAGS = ODINGenerator.Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _odinGeneratorFeatures = DEFAULT_ODIN_GENERATOR_FEATURE_FLAGS;
    private MappingJsonFactory jsonFactory;
    protected final Charset UTF8 = Charset.forName("UTF-8");

    public ODINFactory(MappingJsonFactory jsonFactory) {
        this(jsonFactory, null);
        this.jsonFactory = jsonFactory;
    }

    public ODINFactory(MappingJsonFactory jsonFactory, ObjectCodec oc) {
        super(oc);
        this._odinGeneratorFeatures = DEFAULT_ODIN_GENERATOR_FEATURE_FLAGS;
    }

    public ODINFactory(MappingJsonFactory jsonFactory, ODINFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this.jsonFactory = jsonFactory;
        this._odinGeneratorFeatures = src._odinGeneratorFeatures;
    }

    public ODINFactory copy() {
        this._checkInvalidCopy(ODINFactory.class);
        return new ODINFactory(this.jsonFactory, this, null);
    }

    protected Object readResolve() {
        return new ODINFactory(this.jsonFactory, this, this._objectCodec);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canUseCharArrays() {
        return false;
    }

    public String getFormatName() {
        return FORMAT_NAME_ODIN;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final ODINFactory configure(ODINGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public ODINFactory enable(ODINGenerator.Feature f) {
        this._odinGeneratorFeatures |= f.getMask();
        return this;
    }

    public ODINFactory disable(ODINGenerator.Feature f) {
        this._odinGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(ODINGenerator.Feature f) {
        return (this._odinGeneratorFeatures & f.getMask()) != 0;
    }

    public JsonParser createParser(String content) throws IOException {
        return null;
    }

    public JsonParser createParser(File f) throws IOException {
        return this.jsonFactory.createParser(f);
    }

    public JsonParser createParser(URL url) throws IOException {
        return this.jsonFactory.createParser(url);
    }

    public JsonParser createParser(InputStream in) throws IOException {
        return this.jsonFactory.createParser(in);
    }

    public JsonParser createParser(Reader r) throws IOException {
        return this.jsonFactory.createParser(r);
    }

    public JsonParser createParser(char[] data) throws IOException {
        return this.jsonFactory.createParser(data);
    }

    public JsonParser createParser(char[] data, int offset, int len) throws IOException {
        return this.jsonFactory.createParser(data, offset, len);
    }

    public JsonParser createParser(byte[] data) throws IOException {
        return this.jsonFactory.createParser(data);
    }

    public JsonParser createParser(byte[] data, int offset, int len) throws IOException {
        return this.jsonFactory.createParser(data, offset, len);
    }

    public ODINGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        ctxt.setEncoding(enc);
        return this._createGenerator(this._createWriter(this._decorate(out, ctxt), enc, ctxt), ctxt);
    }

    public ODINGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(this._createWriter(this._decorate(out, ctxt), JsonEncoding.UTF8, ctxt), ctxt);
    }

    public ODINGenerator createGenerator(Writer out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    public JsonGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(f, true);
        ctxt.setEncoding(enc);
        return this._createGenerator(this._createWriter(this._decorate(out, ctxt), enc, ctxt), ctxt);
    }

    protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        return super._createParser(in, ctxt);
    }

    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        return super._createParser(r, ctxt);
    }

    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        return super._createParser(data, offset, len, ctxt, recyclable);
    }

    protected JsonParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return super._createParser(data, offset, len, ctxt);
    }

    protected ODINGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        int feats = this._odinGeneratorFeatures;
        ODINGenerator gen = new ODINGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        return gen;
    }

    protected ODINGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        throw new IllegalStateException();
    }
}

