/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.odin;

import com.nedap.archie.serializer.odin.StructuredStringAppendable;
import java.util.Arrays;

public class StructureStringBuilder
implements StructuredStringAppendable {
    private static final int INDENTATION_SIZE = 4;
    private final StringBuilder builder = new StringBuilder();
    private int indentDepth = 0;
    private boolean startOfLine = true;
    private int startOfLineIndex = 0;

    public static String padRight(String str, int size) {
        return StructureStringBuilder.padRight(str, size, ' ');
    }

    private static String padRight(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        return str + StructureStringBuilder.padding(padChar, pads);
    }

    private static String padding(char padChar, int repeat) throws IndexOutOfBoundsException {
        char[] buf = new char[repeat];
        Arrays.fill(buf, padChar);
        return new String(buf);
    }

    @Override
    public StructureStringBuilder append(Object str) {
        this.builder.append(str);
        this.startOfLine = false;
        return this;
    }

    @Override
    public StructureStringBuilder tryNewLine() {
        if (!this.startOfLine) {
            return this.newline();
        }
        this.resetLineIndentation();
        return this;
    }

    @Override
    public StructureStringBuilder newline() {
        this.builder.append("\n");
        this.startOfLineIndex = this.builder.length();
        this.appendIndentation();
        this.startOfLine = true;
        return this;
    }

    @Override
    public StructureStringBuilder indent() {
        ++this.indentDepth;
        return this;
    }

    @Override
    public StructureStringBuilder newIndentedLine() {
        return this.indent().newline();
    }

    @Override
    public StructureStringBuilder unindent() {
        --this.indentDepth;
        if (this.indentDepth < 0) {
            throw new AssertionError((Object)"Already on root indentation");
        }
        if (this.startOfLine) {
            this.resetLineIndentation();
        }
        return this;
    }

    @Override
    public int mark() {
        return this.builder.length();
    }

    @Override
    public void clearMark() {
    }

    @Override
    public void revert(int previousMark) {
        this.builder.setLength(previousMark);
    }

    @Override
    public StructuredStringAppendable ensureSpace() {
        if (this.builder.length() == 0) {
            return this;
        }
        char lastChar = this.builder.charAt(this.builder.length() - 1);
        if (Character.isWhitespace(lastChar)) {
            return this;
        }
        this.builder.append(" ");
        return this;
    }

    private void resetLineIndentation() {
        this.builder.setLength(this.startOfLineIndex);
        this.appendIndentation();
    }

    private void appendIndentation() {
        this.builder.append(StructureStringBuilder.padding(' ', this.indentDepth * 4));
    }

    public String toString() {
        return this.builder.toString();
    }
}

