/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.odin;

import com.nedap.archie.serializer.odin.StructureStringBuilder;
import com.nedap.archie.serializer.odin.StructuredStringAppendable;
import java.net.URI;

public class OdinStringBuilder {
    private final StructuredStringAppendable builder;

    public OdinStringBuilder(StructuredStringAppendable builder) {
        this.builder = builder;
    }

    public OdinStringBuilder() {
        this(new StructureStringBuilder());
    }

    public static String quoteText(String str) {
        return "\"" + OdinStringBuilder.escapeText(str) + "\"";
    }

    public static String quoteChar(char c) {
        return "'" + OdinStringBuilder.escapeText(Character.toString(c)) + "'";
    }

    private static String escapeText(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public OdinStringBuilder append(Object str) {
        this.builder.append(str);
        return this;
    }

    public OdinStringBuilder text(String str) {
        return this.append(OdinStringBuilder.quoteText(str));
    }

    public OdinStringBuilder tryNewLine() {
        this.builder.tryNewLine();
        return this;
    }

    public OdinStringBuilder newline() {
        this.builder.newline();
        return this;
    }

    public OdinStringBuilder indent() {
        this.builder.indent();
        return this;
    }

    public OdinStringBuilder newIndentedline() {
        return this.indent().newline();
    }

    public OdinStringBuilder unindent() {
        this.builder.unindent();
        return this;
    }

    public OdinStringBuilder newUnindentedLine() {
        return this.unindent().newline();
    }

    public OdinStringBuilder character(char c) {
        return this.append(OdinStringBuilder.quoteChar(c));
    }

    public String toString() {
        return this.builder.toString();
    }

    public OdinStringBuilder number(Number n) {
        return this.append(n);
    }

    public OdinStringBuilder bool(boolean bool) {
        return this.append(bool ? "True" : "False");
    }

    public OdinStringBuilder uri(URI uri) {
        return this.append(uri.toString());
    }
}

