/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.odin.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.nedap.archie.serializer.odin.OdinStringBuilder;
import com.nedap.archie.serializer.odin.StructuredStringWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.openehr.odin.jackson.PackageVersion;

public class ODINGenerator
extends GeneratorBase {
    private OdinStringBuilder builder;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected static final Pattern PLAIN_NUMBER_P = Pattern.compile("[0-9]*(\\.[0-9]*)?");
    protected final IOContext _ioContext;
    protected int _formatFeatures;
    protected Writer _writer;
    private static final Character STYLE_NAME = null;
    private static final Character STYLE_SCALAR = null;
    private static final Character STYLE_QUOTED = Character.valueOf('\"');
    private static final Character STYLE_LITERAL;
    private static final Character STYLE_BASE64;
    private static final Character STYLE_PLAIN;
    protected String _objectId;
    protected String _typeId;

    public ODINGenerator(IOContext ctxt, int jsonFeatures, int odinFeatures, ObjectCodec codec, Writer out) throws IOException {
        super(jsonFeatures, codec);
        this._ioContext = ctxt;
        this._formatFeatures = odinFeatures;
        this._writer = out;
        this.builder = new OdinStringBuilder(new StructuredStringWriter(out));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ODINGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public ODINGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public boolean canWriteFormattedNumbers() {
        return true;
    }

    public ODINGenerator enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public ODINGenerator disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public ODINGenerator configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public void writeObject(Object pojo) throws IOException {
    }

    public final void writeFieldName(String name) throws IOException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.builder.tryNewLine().append(name).append(" = ");
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        this.writeFieldName(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.writeFieldName(fieldName);
        this.writeFieldStart();
        this.writeString(value);
        this.writeFieldStart();
    }

    public final void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        if (!this.isClosed()) {
            this._writer.close();
        }
    }

    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        this.builder.append("<");
    }

    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        int index = this._writeContext.getCurrentIndex();
        if (index == 0) {
            this.builder.append(", ...");
        }
        this.builder.append(">");
        this._writeContext = this._writeContext.getParent();
    }

    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        if (this._writeContext.inArray()) {
            if (this._writeContext.getCurrentIndex() == 0) {
                this.builder.indent();
            }
            this.builder.newline().append("[" + (this._writeContext.getCurrentIndex() + 1) + "] = ");
        }
        if (!this._writeContext.inRoot()) {
            this.builder.append("<").indent();
        }
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        if (this._writeContext.inArray()) {
            this.builder.newUnindentedLine().append(">");
        } else if (!this._writeContext.inRoot()) {
            this.builder.newUnindentedLine().append(">");
        }
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this.writeFieldStart();
        this.builder.text(text);
        this.writeFieldEnd();
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    public final void writeString(SerializableString sstr) throws IOException {
        this.writeString(sstr.toString());
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    public void writeRaw(String text) throws IOException {
        this.builder.append(text);
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        this.builder.append(new String(text.getBytes(), offset, len));
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this.builder.append(new String(text, offset, len));
    }

    public void writeRaw(char c) throws IOException {
        this.builder.append(Character.valueOf(c));
    }

    public void writeRawValue(String text) throws IOException {
        this._verifyValueWrite("write String value");
        this.writeFieldStart();
        this.builder.append(text);
        this.writeFieldEnd();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        this._writeScalarBinary(b64variant, data);
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        this.writeFieldStart();
        this.builder.append(state ? "True" : "False");
        this.writeFieldEnd();
    }

    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.append(Integer.toString(i));
        this.writeFieldEnd();
    }

    public void writeNumber(long l) throws IOException {
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.append(Long.toString(l));
        this.writeFieldEnd();
    }

    private void writeFieldStart() {
        if (!this._writeContext.inArray()) {
            this.builder.append("<");
        }
    }

    private void writeFieldEnd() {
        if (!this._writeContext.inArray()) {
            this.builder.append(">");
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.append(String.valueOf(v.toString()));
        this.writeFieldEnd();
    }

    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.append(Double.toString(d));
        this.writeFieldEnd();
    }

    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.append(Float.toString(f));
        this.writeFieldEnd();
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this.writeFieldStart();
        this.builder.append(str);
        this.writeFieldEnd();
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this.writeFieldStart();
        this.builder.text(encodedValue);
        this.writeFieldEnd();
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this.writeFieldStart();
        this.writeFieldEnd();
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return true;
    }

    public void writeTypeId(Object id) throws IOException {
        this._typeId = String.valueOf(id);
        this.builder.append("(").append(id.toString()).append(") ");
    }

    public void writeObjectRef(Object id) throws IOException {
        this._verifyValueWrite("write Object reference");
    }

    public void writeObjectId(Object id) throws IOException {
        this._objectId = String.valueOf(id);
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
        if (status == 1 && this._writeContext.inArray()) {
            this.builder.append(", ");
        }
    }

    protected void _releaseBuffers() {
    }

    private void _writeScalarBinary(Base64Variant b64variant, byte[] data) throws IOException {
        if (b64variant == Base64Variants.getDefaultVariant()) {
            b64variant = Base64Variants.MIME;
        }
        String encoded = b64variant.encode(data);
        this.builder.text(encoded);
    }

    static {
        STYLE_BASE64 = STYLE_LITERAL = Character.valueOf('|');
        STYLE_PLAIN = null;
    }

    public static enum Feature implements FormatFeature
    {

        protected final boolean _defaultState;
        protected final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

