/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.odin;

import com.nedap.archie.serializer.odin.StructuredStringAppendable;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class StructuredStringWriter
implements StructuredStringAppendable {
    private static final int INDENTATION_SIZE = 4;
    private final Writer writer;
    private int indentDepth = 0;
    private boolean startOfLine = true;
    private boolean lastCharacterWasSpace = false;
    private boolean marked = false;
    private StringBuilder markedContent = new StringBuilder();

    public StructuredStringWriter(Writer writer) {
        this.writer = writer;
    }

    private static String padding(char padChar, int repeat) throws IndexOutOfBoundsException {
        char[] buf = new char[repeat];
        Arrays.fill(buf, padChar);
        return new String(buf);
    }

    @Override
    public StructuredStringWriter append(Object str) {
        this.checkIndentBeforeWrite();
        this.write(str.toString());
        this.startOfLine = false;
        return this;
    }

    @Override
    public StructuredStringWriter tryNewLine() {
        if (!this.startOfLine) {
            return this.newline();
        }
        return this;
    }

    @Override
    public StructuredStringWriter newline() {
        this.write("\n");
        this.startOfLine = true;
        return this;
    }

    @Override
    public StructuredStringWriter indent() {
        ++this.indentDepth;
        return this;
    }

    @Override
    public StructuredStringWriter newIndentedLine() {
        return this.indent().newline();
    }

    @Override
    public StructuredStringWriter unindent() {
        --this.indentDepth;
        if (this.indentDepth < 0) {
            throw new AssertionError((Object)"Already on root indentation");
        }
        return this;
    }

    @Override
    public int mark() {
        if (this.marked) {
            return this.markedContent.length();
        }
        this.marked = true;
        return 0;
    }

    @Override
    public void revert(int previousMark) {
        if (!this.marked) {
            throw new IllegalStateException("cannot revert without being in the marked state");
        }
        if (previousMark == 0) {
            this.markedContent.setLength(0);
            this.marked = false;
        } else {
            this.markedContent.setLength(previousMark);
        }
    }

    @Override
    public void clearMark() {
        this.marked = false;
        this.write(this.markedContent.toString());
        this.markedContent.setLength(0);
    }

    @Override
    public StructuredStringAppendable ensureSpace() {
        if (!this.lastCharacterWasSpace) {
            this.write(" ");
            this.lastCharacterWasSpace = true;
        }
        return this;
    }

    private void checkIndentBeforeWrite() {
        if (this.startOfLine && this.indentDepth > 0) {
            this.write(StructuredStringWriter.padding(' ', this.indentDepth * 4));
            this.startOfLine = false;
        }
    }

    private void write(String s) {
        this.lastCharacterWasSpace = !s.isEmpty() && s.charAt(s.length() - 1) == ' ';
        if (this.marked) {
            this.markedContent.append(s);
        } else {
            try {
                this.writer.write(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

