/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.odin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.nedap.archie.adlparser.antlr.AdlParser;
import java.io.IOException;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class AdlOdinToJsonConverter {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private StringBuilder output = new StringBuilder();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static void configureObjectMapper(ObjectMapper objectMapper, boolean allowDuplicates) {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        if (!allowDuplicates) {
            objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        } else {
            objectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        }
        objectMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                if (propertyName.equalsIgnoreCase("@type")) {
                    return true;
                }
                return super.handleUnknownProperty(ctxt, p, deserializer, beanOrClass, propertyName);
            }
        });
    }

    public String convert(AdlParser.Odin_textContext context) {
        if (context == null) {
            return "{}";
        }
        if (context.attr_vals() != null) {
            this.output(context.attr_vals().attr_val(), null);
        } else if (context.object_value_block() != null) {
            this.output(context.object_value_block());
        } else if (context.keyed_object() != null && context.keyed_object().size() > 0) {
            this.outputKeyedObjects(context.keyed_object(), null);
        } else {
            return "{}";
        }
        return this.output.toString();
    }

    private void output(List<AdlParser.Attr_valContext> context, AdlParser.Type_idContext type_idContext) {
        this.output.append("{");
        boolean first = true;
        if (type_idContext != null) {
            first = false;
            this.outputTypeId(type_idContext);
        }
        for (AdlParser.Attr_valContext attrValContext : context) {
            if (!first) {
                this.output.append(',');
            }
            first = false;
            this.output.append('\"');
            this.output.append(attrValContext.attribute_id().getText());
            this.output.append('\"');
            this.output.append(':');
            this.output(attrValContext.object_block());
        }
        this.output.append("}");
    }

    private void outputTypeId(AdlParser.Type_idContext type_idContext) {
        this.outputEscaped("@type");
        this.output.append(":");
        this.outputEscaped(type_idContext.getText());
    }

    private void output(AdlParser.Object_blockContext context) {
        AdlParser.Object_value_blockContext valueBlockContext = context.object_value_block();
        if (context.object_reference_block() == null) {
            if (valueBlockContext != null) {
                this.output(valueBlockContext);
            } else {
                this.output.append("{}");
            }
        }
    }

    private void output(AdlParser.Object_value_blockContext valueBlockContext) {
        List keyedObjectContexts = valueBlockContext.keyed_object();
        AdlParser.Primitive_objectContext primitiveObjectContext = valueBlockContext.primitive_object();
        if (valueBlockContext.attr_vals() != null) {
            this.output(valueBlockContext.attr_vals().attr_val(), valueBlockContext.type_id());
        } else if (keyedObjectContexts != null && !keyedObjectContexts.isEmpty()) {
            this.outputKeyedObjects(keyedObjectContexts, valueBlockContext.type_id());
        } else if (primitiveObjectContext != null) {
            if (primitiveObjectContext.primitive_value() != null) {
                this.output(primitiveObjectContext.primitive_value());
            } else if (primitiveObjectContext.primitive_list_value() != null) {
                AdlParser.Primitive_list_valueContext listContext = primitiveObjectContext.primitive_list_value();
                this.output(listContext);
            } else {
                this.output.append("{ \"@type\": \"INTERVAL\" ");
                AdlParser.Primitive_interval_valueContext intervalCtx = primitiveObjectContext.primitive_interval_value();
                if (intervalCtx.date_interval_value() == null && intervalCtx.duration_interval_value() == null) {
                    if (intervalCtx.integer_interval_value() != null) {
                        AdlParser.Integer_interval_valueContext interval = intervalCtx.integer_interval_value();
                        if (interval.relop() != null) {
                            String relopText = interval.relop().getText();
                            if (relopText.contains(">")) {
                                this.output.append(",\"lower_unbounded\": \"false\"");
                                this.output.append(",\"upper_unbounded\": \"true\"");
                                this.output.append(",\"lower\": " + ((AdlParser.Integer_valueContext)interval.integer_value().get(0)).getText());
                                if (relopText.contains("=")) {
                                    this.output.append(",\"lower_included\": \"true\"");
                                } else {
                                    this.output.append(",\"lower_included\": \"false\"");
                                }
                            } else if (relopText.contains("<")) {
                                this.output.append(",\"lower_unbounded\": \"true\"");
                                this.output.append(",\"upper_unbounded\": \"false\"");
                                this.output.append(",\"upper\": " + ((AdlParser.Integer_valueContext)interval.integer_value().get(0)).getText());
                                if (relopText.contains("=")) {
                                    this.output.append(",\"upper_included\": \"true\"");
                                } else {
                                    this.output.append(",\"upper_included\": \"false\"");
                                }
                            }
                        } else {
                            this.output.append(",\"lower_unbounded\": \"false\"");
                            this.output.append(",\"upper_unbounded\": \"false\"");
                            if (interval.SYM_GT() != null) {
                                this.output.append(",\"lower_included\": \"false\"");
                            } else {
                                this.output.append(",\"lower_included\": \"true\"");
                            }
                            if (interval.SYM_LT() != null) {
                                this.output.append(",\"upper_included\": \"false\"");
                            } else {
                                this.output.append(",\"upper_included\": \"true\"");
                            }
                            this.output.append(",\"lower\": " + ((AdlParser.Integer_valueContext)interval.integer_value().get(0)).getText());
                            if (interval.integer_value().size() > 1) {
                                this.output.append(",\"upper\": " + ((AdlParser.Integer_valueContext)interval.integer_value().get(1)).getText());
                            } else {
                                this.output.append(",\"upper\": " + ((AdlParser.Integer_valueContext)interval.integer_value().get(0)).getText());
                            }
                        }
                    } else if (intervalCtx.real_interval_value() != null) {
                        AdlParser.Real_interval_valueContext interval = intervalCtx.real_interval_value();
                        if (interval.relop() != null) {
                            String relopText = interval.relop().getText();
                            if (relopText.contains(">")) {
                                this.output.append(",\"lower_unbounded\": \"false\"");
                                this.output.append(",\"upper_unbounded\": \"true\"");
                                this.output.append(",\"lower\": " + ((AdlParser.Real_valueContext)interval.real_value().get(0)).getText());
                                if (relopText.contains("=")) {
                                    this.output.append(",\"lower_included\": \"true\"");
                                } else {
                                    this.output.append(",\"lower_included\": \"false\"");
                                }
                            } else if (relopText.contains("<")) {
                                this.output.append(",\"lower_unbounded\": \"true\"");
                                this.output.append(",\"upper_unbounded\": \"false\"");
                                this.output.append(",\"upper\": " + ((AdlParser.Real_valueContext)interval.real_value().get(0)).getText());
                                if (relopText.contains("=")) {
                                    this.output.append(",\"upper_included\": \"true\"");
                                } else {
                                    this.output.append(",\"upper_included\": \"false\"");
                                }
                            }
                        } else {
                            this.output.append(",\"lower_unbounded\": \"false\"");
                            this.output.append(",\"upper_unbounded\": \"false\"");
                            if (interval.SYM_GT() != null) {
                                this.output.append(",\"lower_included\": \"false\"");
                            } else {
                                this.output.append(",\"lower_included\": \"true\"");
                            }
                            if (interval.SYM_LT() != null) {
                                this.output.append(",\"upper_included\": \"false\"");
                            } else {
                                this.output.append(",\"upper_included\": \"true\"");
                            }
                            this.output.append(",\"lower\": " + ((AdlParser.Real_valueContext)interval.real_value().get(0)).getText());
                            if (interval.real_value().size() > 1) {
                                this.output.append(",\"upper\": " + ((AdlParser.Real_valueContext)interval.real_value().get(1)).getText());
                            } else {
                                this.output.append(",\"upper\": " + ((AdlParser.Real_valueContext)interval.real_value().get(0)).getText());
                            }
                        }
                    } else if (intervalCtx.date_time_interval_value() != null || intervalCtx.time_interval_value() != null) {
                        // empty if block
                    }
                }
                this.output.append("}");
            }
        } else {
            this.output.append("[]");
        }
    }

    private void outputKeyedObjects(List<AdlParser.Keyed_objectContext> keyedObjectContexts, AdlParser.Type_idContext type_idContext) {
        this.output.append("{");
        boolean first = true;
        if (type_idContext != null) {
            first = false;
            this.outputTypeId(type_idContext);
        }
        for (AdlParser.Keyed_objectContext keyedObjectContext : keyedObjectContexts) {
            if (!first) {
                this.output.append(',');
            }
            first = false;
            this.output(keyedObjectContext.primitive_value());
            this.output.append(':');
            this.output(keyedObjectContext.object_block());
        }
        this.output.append("}");
    }

    private void output(AdlParser.Primitive_list_valueContext listContext) {
        List primitiveValueContexts = listContext.primitive_value();
        this.output.append("[");
        boolean first = true;
        for (AdlParser.Primitive_valueContext valueContext : primitiveValueContexts) {
            if (!first) {
                this.output.append(',');
            }
            first = false;
            this.output(valueContext);
        }
        this.output.append("]");
    }

    private void output(AdlParser.Primitive_valueContext context) {
        if (context.uri_value() != null) {
            this.outputString(context.getText());
        } else if (context.date_time_value() != null) {
            this.outputString(context.getText());
        } else if (context.date_value() != null) {
            this.outputString(context.getText());
        } else if (context.duration_value() != null) {
            this.outputString(context.getText());
        } else if (context.time_value() != null) {
            this.outputString(context.getText());
        } else if (context.term_code_value() != null) {
            this.outputString(context.getText());
        } else if (context.boolean_value() != null) {
            if (context.boolean_value().getText().equalsIgnoreCase("true")) {
                this.output.append("true");
            } else {
                this.output.append("false");
            }
        } else {
            this.outputEscaped(context.getText());
        }
    }

    private void outputString(String text) {
        try {
            this.output.append(objectMapper.writeValueAsString((Object)text));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void outputEscaped(String text) {
        try {
            if (text.startsWith("\"") && text.endsWith("\"")) {
                String textWithoutQuotationMarks = text.substring(1, text.length() - 1);
                String textQuotesReplaced = StringEscapeUtils.unescapeJson((String)textWithoutQuotationMarks);
                this.output.append(objectMapper.writeValueAsString((Object)textQuotesReplaced));
            } else {
                this.output.append(objectMapper.writeValueAsString((Object)text));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOutput() {
        return this.output.toString();
    }

    static {
        AdlOdinToJsonConverter.configureObjectMapper(objectMapper, false);
    }
}

