/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmContainerProperty;
import org.openehr.bmm.v2.persistence.PBmmContainerType;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmGenericProperty;
import org.openehr.bmm.v2.persistence.PBmmGenericType;
import org.openehr.bmm.v2.persistence.PBmmOpenType;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmSingleProperty;
import org.openehr.bmm.v2.persistence.PBmmSinglePropertyOpen;
import org.openehr.bmm.v2.persistence.PBmmType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;
import org.openehr.bmm.v2.validation.validators.ConformanceChecker;
import org.openehr.bmm.v2.validation.validators.ValidatorBase;
import org.openehr.utils.message.MessageLogger;

public class PropertyValidator
extends ValidatorBase {
    private final PBmmSchema schema;
    private MessageLogger logger;
    private ConformanceChecker conformanceChecker = new ConformanceChecker();

    public PropertyValidator(MessageLogger logger, PBmmSchema schema) {
        super(logger);
        this.logger = logger;
        this.schema = schema;
    }

    public void validateProperty(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        this.validateOverriddenPropertyType(pBmmClass, pBmmProperty);
        if (pBmmProperty instanceof PBmmSingleProperty) {
            this.validateSingleProperty(pBmmClass, pBmmProperty);
        } else if (pBmmProperty instanceof PBmmSinglePropertyOpen) {
            this.validateSimpleOpenProperty(pBmmClass, pBmmProperty);
        } else if (pBmmProperty instanceof PBmmContainerProperty) {
            this.validateContainerProperty(pBmmClass, pBmmProperty);
        } else if (pBmmProperty instanceof PBmmGenericProperty) {
            this.validateGenericProperty(pBmmClass, pBmmProperty);
        }
    }

    private void validateGenericProperty(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        PBmmGenericProperty genericPropertyDefinition = (PBmmGenericProperty)pBmmProperty;
        PBmmGenericType attributeTypeDefinition = (PBmmGenericType)((Object)genericPropertyDefinition.getTypeDef());
        if (attributeTypeDefinition != null) {
            if (!this.schema.hasClassOrPrimitiveDefinition(attributeTypeDefinition.getRootType())) {
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PROPERTY_ROOT_TYPE_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getRootType());
            }
            for (PBmmType genericParameter : attributeTypeDefinition.getGenericParameterDefs().values()) {
                this.validateGenericTypeDefParameter(pBmmClass, pBmmProperty, attributeTypeDefinition, genericParameter);
            }
        } else {
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PROPERTY_TYPE_DEF_UNDEFINED, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName());
        }
    }

    private void validateGenericTypeDefParameter(PBmmClass pBmmClass, PBmmProperty pBmmProperty, PBmmGenericType attributeTypeDefinition, PBmmType genericParameter) {
        List<String> typeReferences = genericParameter.flattenedTypeList();
        for (String typeReference : typeReferences) {
            if (this.schema.hasClassOrPrimitiveDefinition(typeReference)) continue;
            if (pBmmClass.isGeneric()) {
                Map<String, PBmmGenericParameter> genericParameters = pBmmClass.getGenericParameterDefs();
                if (genericParameters.containsKey(typeReference)) continue;
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PROPERTY_TYPE_PARAMETER_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getRootType());
                continue;
            }
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PARAMETER_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), typeReference);
        }
    }

    private void validateContainerProperty(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        PBmmContainerProperty containerPropertyDefinition = (PBmmContainerProperty)pBmmProperty;
        PBmmContainerType attributeTypeDefinition = (PBmmContainerType)((Object)containerPropertyDefinition.getTypeRef());
        PBmmUnitaryType attributeTypeReference = attributeTypeDefinition.getTypeRef();
        if (!this.schema.hasClassOrPrimitiveDefinition(attributeTypeDefinition.getContainerType())) {
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_CONTAINER_TYPE_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getType());
        } else if (attributeTypeReference != null) {
            List<String> typeReferences = attributeTypeReference.flattenedTypeList();
            if (typeReferences != null) {
                for (String typeReference : typeReferences) {
                    this.validateContainerTypeReference(pBmmClass, pBmmProperty, attributeTypeDefinition, typeReference);
                }
            }
        } else {
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_CONTAINER_PROPERTY_TARGET_TYPE_NOT_DEFINED, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName());
        }
        if (containerPropertyDefinition.getCardinality() == null) {
            // empty if block
        }
    }

    private void validateContainerTypeReference(PBmmClass pBmmClass, PBmmProperty pBmmProperty, PBmmContainerType attributeTypeDefinition, String typeReference) {
        if (!this.schema.hasClassOrPrimitiveDefinition(typeReference)) {
            if (pBmmClass.isGeneric()) {
                Map<String, PBmmGenericParameter> genericParameters = pBmmClass.getGenericParameterDefs();
                if (!genericParameters.containsKey(typeReference)) {
                    this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PROPERTY_TYPE_PARAMETER_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getType());
                }
            } else {
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_CONTAINER_PROPERTY_TARGET_TYPE_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getType());
            }
        }
    }

    private void validateSimpleOpenProperty(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        PBmmSinglePropertyOpen singlePropertyOpenDefinition = (PBmmSinglePropertyOpen)pBmmProperty;
        PBmmOpenType attributeTypeDefinition = singlePropertyOpenDefinition.getTypeRef();
        if (!pBmmClass.isGeneric() || !pBmmClass.getGenericParameterDefs().containsKey(attributeTypeDefinition.getType())) {
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_SINGLE_OPEN_PARAMETER_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getType());
        }
    }

    private void validateSingleProperty(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        PBmmSingleProperty singlePropertyDefinition = (PBmmSingleProperty)pBmmProperty;
        PBmmSimpleType attributeTypeDefinition = singlePropertyDefinition.getTypeRef();
        if (StringUtils.isEmpty((CharSequence)attributeTypeDefinition.getType()) || !this.schema.hasClassOrPrimitiveDefinition(attributeTypeDefinition.getType())) {
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_SINGLE_PROPERTY_TYPE_NOT_FOUND, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), attributeTypeDefinition.getType());
        }
    }

    private void validateOverriddenPropertyType(PBmmClass pBmmClass, PBmmProperty pBmmProperty) {
        for (String ancestorName : pBmmClass.getAncestorTypeNames()) {
            PBmmClass ancestor = this.schema.getClassDefinition(BmmDefinitions.typeNameToClassKey(ancestorName));
            if (ancestor == null) continue;
            PBmmProperty ancestorProperty = ancestor.getProperties().get(pBmmProperty.getName());
            if (ancestor == null || ancestorProperty == null || this.conformanceChecker.propertyConformsTo(this.schema, pBmmProperty, ancestorProperty)) continue;
            this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_OVERRIDDEN_PROPERTY_DOES_NOT_CONFORM, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmProperty.getName(), ancestorName);
        }
    }
}

