/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmPackageContainer;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmValidation;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageLogger;

public class BasicSchemaValidations
implements BmmValidation {
    @Override
    public void validate(BmmValidationResult validationResult, BmmRepository repository, MessageLogger logger, PBmmSchema schema) {
        if (!BmmDefinitions.isValidStandardVersion(schema.getRmRelease())) {
            logger.addError((MessageCode)BmmMessageIds.EC_RM_RELEASE_INVALID, new Object[]{schema.getSchemaId(), schema.getRmRelease()});
        }
        if (schema.getArchetypeParentClass() != null && schema.getClassDefinition(schema.getArchetypeParentClass()) == null) {
            logger.addError((MessageCode)BmmMessageIds.EC_ARCHETYPE_PARENT_CLASS_UNDEFINED, new Object[]{schema.getSchemaId(), schema.getArchetypeParentClass()});
        }
        schema.getArchetypeRmClosurePackages().forEach(closurePackage -> {
            if (!this.hasCanonicalPackagePath(validationResult, schema, (String)closurePackage)) {
                logger.addError((MessageCode)BmmMessageIds.ec_BMM_MDLPK, new Object[]{schema.getSchemaId(), closurePackage});
            }
        });
        HashMap packageClassList = new HashMap();
        validationResult.getCanonicalPackages().forEach((packageName, canonicalPackage) -> canonicalPackage.doRecursiveClasses((persistedBmmPackage, className) -> {
            String classNameStr = className.toLowerCase();
            if (packageClassList.containsKey(classNameStr)) {
                logger.addError((MessageCode)BmmMessageIds.EC_DUPLICATE_CLASS_IN_PACKAGES, new Object[]{schema.getSchemaId(), className, persistedBmmPackage.getName(), packageClassList.get(classNameStr)});
            } else {
                packageClassList.put(classNameStr, persistedBmmPackage.getName());
            }
        }));
        ArrayList classNameList = new ArrayList();
        schema.doAllClasses(persistedBmmClass -> {
            String className = persistedBmmClass.getName().toLowerCase();
            if (!packageClassList.containsKey(className)) {
                logger.addError((MessageCode)BmmMessageIds.EC_CLASS_NOT_DECLARED_IN_PACKAGES, new Object[]{schema.getSchemaId(), persistedBmmClass.getName()});
            } else if (classNameList.contains(className)) {
                logger.addError((MessageCode)BmmMessageIds.EC_DUPLICATE_CLASS_DEFINITION, new Object[]{schema.getSchemaId(), persistedBmmClass.getName()});
            } else {
                classNameList.add(className);
            }
        });
    }

    public boolean hasCanonicalPackagePath(final BmmValidationResult validationResult, PBmmSchema schema, String aPath) {
        if (StringUtils.isEmpty((CharSequence)aPath)) {
            return false;
        }
        String[] packageNames = aPath.toUpperCase().split("\\" + BmmDefinitions.PACKAGE_NAME_DELIMITER);
        PBmmPackageContainer currentPackage = new PBmmPackageContainer(){

            @Override
            public Map<String, PBmmPackage> getPackages() {
                return validationResult.getCanonicalPackages();
            }
        };
        for (String packageName : packageNames) {
            if ((currentPackage = (PBmmPackageContainer)currentPackage.getPackages().get(packageName)) != null) continue;
            return false;
        }
        return true;
    }
}

