/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmSchemaValidationException;
import org.openehr.bmm.v2.validation.BmmSchemaValidator;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.bmm.v2.validation.converters.BmmModelCreator;
import org.openehr.bmm.v2.validation.converters.CanonicalPackagesGenerator;
import org.openehr.bmm.v2.validation.converters.DescendantsCalculator;
import org.openehr.bmm.v2.validation.converters.IncludesProcessor;
import org.openehr.bmm.v2.validation.converters.PreprocessPersistedSchema;
import org.openehr.utils.message.MessageCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmmSchemaConverter {
    private static final Logger logger = LoggerFactory.getLogger(BmmSchemaConverter.class);
    private final BmmRepository repository;
    private BmmSchemaValidator schemaValidator;

    public BmmSchemaConverter(BmmRepository repository) {
        this.repository = repository;
        this.schemaValidator = new BmmSchemaValidator(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BmmValidationResult validateConvertAndAddToRepo(PBmmSchema schema) {
        this.schemaValidator = new BmmSchemaValidator(this.repository);
        logger.info("loading " + schema.getSchemaId());
        BmmValidationResult result = new BmmValidationResult();
        result.setLogger(this.schemaValidator.getLogger());
        result.setSchemaId(schema.getSchemaId());
        result.setOriginalSchema(schema);
        try {
            this.schemaValidator.validateCreated(result, schema);
            this.schemaValidator.checkNoExceptions();
            this.schemaValidator.validateBmmVersion(result, schema);
            this.schemaValidator.checkNoExceptions();
            this.schemaValidator.validateIncludes(result, schema);
            this.schemaValidator.checkNoExceptions();
            new PreprocessPersistedSchema().preprocess(schema);
            Map<String, PBmmPackage> canonicalPackages = new CanonicalPackagesGenerator().generateCanonicalPackages(schema);
            result.setCanonicalPackages(canonicalPackages);
            new IncludesProcessor().cloneSchemaAndAddIncludes(result, this.repository, this.schemaValidator.getLogger());
            this.schemaValidator.checkNoExceptions();
            this.schemaValidator.validateSchemaAfterMergeOfIncludes(result);
            this.schemaValidator.checkNoExceptions();
            BmmModel bmmModel = new BmmModelCreator().create(result);
            this.schemaValidator.checkNoExceptions();
            new DescendantsCalculator().calculateDescendants(bmmModel);
            result.setModel(bmmModel);
            this.createModelsByClosureAndVersion(result);
            BmmValidationResult bmmValidationResult = result;
            return bmmValidationResult;
        }
        catch (BmmSchemaValidationException ex) {
            BmmValidationResult bmmValidationResult = result;
            return bmmValidationResult;
        }
        catch (Exception e) {
            result.getLogger().addError((MessageCode)BmmMessageIds.ec_bmm_schema_conv_fail_err, new Object[]{schema.getSchemaName(), e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e)});
            BmmValidationResult bmmValidationResult = result;
            return bmmValidationResult;
        }
        finally {
            this.repository.addModel(result);
        }
    }

    public void validateAndConvertRepository() {
        for (PBmmSchema schema : this.repository.getPersistentSchemas()) {
            if (this.repository.getModel(schema.getSchemaId()) != null) continue;
            BmmValidationResult bmmValidationResult = this.validateConvertAndAddToRepo(schema);
        }
    }

    private void createModelsByClosureAndVersion(BmmValidationResult validationResult) {
        BmmModel model = validationResult.getModel();
        ArrayList rmClosures = new ArrayList();
        String schemaId = model.getSchemaId();
        String modelPublisher = model.getRmPublisher();
        String modelName = model.getModelName();
        if (modelName != null) {
            this.addClosure(schemaId, validationResult, modelPublisher, modelName);
        } else {
            for (String closureName : model.getArchetypeRmClosurePackages()) {
                this.addClosure(schemaId, validationResult, modelPublisher, closureName);
            }
        }
    }

    private void addClosure(String schemaId, BmmValidationResult validationResult, String modelPublisher, String modelName) {
        String qualifiedRmClosureName = BmmDefinitions.publisherQualifiedRmClosureName(modelPublisher, modelName) + "_" + validationResult.getModel().getRmRelease();
        BmmValidationResult existingSchema = this.repository.getModelByClosure(qualifiedRmClosureName);
        if (existingSchema != null) {
            this.schemaValidator.getLogger().addInfo((MessageCode)BmmMessageIds.ec_bmm_schema_duplicate_found, new Object[]{qualifiedRmClosureName, existingSchema.getSchemaId(), schemaId});
        } else {
            this.repository.addModelByClosure(qualifiedRmClosureName, validationResult);
        }
    }
}

