/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.google.common.collect.Lists;
import java.util.List;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmSimpleClass;
import org.openehr.bmm.core.BmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;
import org.openehr.bmm.v2.validation.converters.BmmClassProcessor;

public final class PBmmSimpleType
extends PBmmUnitaryType {
    private String type;

    public PBmmSimpleType() {
    }

    public PBmmSimpleType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String baseType() {
        return this.type;
    }

    @Override
    public BmmSimpleType createBmmType(BmmClassProcessor classProcessor, BmmClass classDefinition) {
        BmmClass simpleClassDef = classProcessor.getClassDefinition(this.type);
        if (simpleClassDef == null) {
            throw new RuntimeException("BmmClass " + this.type + " is not defined in this model");
        }
        if (simpleClassDef instanceof BmmSimpleClass) {
            return new BmmSimpleType((BmmSimpleClass)simpleClassDef);
        }
        throw new RuntimeException("BmmClass " + this.type + " should be a simple type, but was " + simpleClassDef.getClass().getSimpleName());
    }

    @Override
    public String asTypeString() {
        return this.type;
    }

    @Override
    public List<String> flattenedTypeList() {
        return Lists.newArrayList((Object[])new String[]{this.type});
    }
}

