/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.persistence.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openehr.bmm.persistence.validation.BasicDefinitions;

public class BmmDefinitions
extends BasicDefinitions {
    public static final String BMM_INTERNAL_VERSION = "2.1";
    public static final Character SCHEMA_ID_DELIMITER = Character.valueOf('-');
    public static final String SCHEMA_NAME_DELIMITER = "::";
    public static final Character PACKAGE_NAME_DELIMITER = Character.valueOf('.');
    public static final Character GENERIC_LEFT_DELIMITER = Character.valueOf('<');
    public static final Character GENERIC_RIGHT_DELIMITER = Character.valueOf('>');
    public static final Character GENERIC_SEPARATOR = Character.valueOf(',');
    public static final Character TUPLE_LEFT_DELIMITER = Character.valueOf('[');
    public static final Character TUPLE_RIGHT_DELIMITER = Character.valueOf(']');
    public static final Character TUPLE_SEPARATOR = Character.valueOf(',');
    public static final Character CONSTRAINT_LEFT_DELIMITER = Character.valueOf('\u00ab');
    public static final Character CONSTRAINT_RIGHT_DELIMITER = Character.valueOf('\u00bb');
    public static final Character PATH_DELIMITER = Character.valueOf('/');
    public static final Character GENERIC_CONSTRAINT_DELIMITER = Character.valueOf(':');
    public static final String UNKNOWN_PACKAGE_NAME = "(uninitialized)";
    public static final String UNKNOWN_SCHEMA_ID = "(uninitialized)";
    public static final String UNKNOWN_SCHEMA_NAME = "(uninitialized)";
    public static final String UNKNOWN_TYPE_NAME = "UNKNOWN";
    public static final List<String> BMM_CONTAINER_TYPES = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("List");
            this.add("Set");
            this.add("Array");
        }
    });
    public static final String BMM_SCHEMA_FILE_EXTENSION = ".bmm";
    public static final String BMM_SCHEMA_FILE_MATCH_REGEX = ".*\\.bmm$";
    public static final String METADATA_BMM_VERSION = "bmm_version";
    public static final String METADATA_RM_PUBLISHER = "rm_publisher";
    public static final String METADATA_SCHEMA_NAME = "schema_name";
    public static final String METADATA_RM_RELEASE = "rm_release";
    public static final String METADATA_SCHEMA_REVISION = "schema_revision";
    public static final String METADATA_SCHEMA_LIFECYCLE_STATE = "schema_lifecycle_state";
    public static final String METADATA_SCHEMA_DESCRIPTION = "schema_description";
    public static final String METADATA_SCHEMA_PATH = "schema_path";
    public static final String ASSUMED_BMM_VERSION = "1.0";
    public static final Pattern WELL_FORMED_TYPE_NAME_REGEX = Pattern.compile("[a-z]\\w*( *< *[a-z]\\w*( *< *[a-z]\\w*( *, *[a-z]\\w+)* *>)?( *, *[a-z]\\w*( *< *[a-z]\\w*( *, *[a-z]\\w+)* *>)?)* *>)?", 2);
    public static final Pattern WELL_FORMED_CLASS_NAME_REGEX = Pattern.compile("[a-z]\\w+", 2);

    public static boolean isValidMetadata(Map<String, String> aMetadata) {
        return aMetadata != null && !aMetadata.isEmpty() && aMetadata.containsKey(METADATA_SCHEMA_NAME) && aMetadata.containsKey(METADATA_RM_RELEASE) && aMetadata.containsKey(METADATA_SCHEMA_PATH);
    }

    public static boolean isWellFormedTypeName(String aTypeName) {
        return WELL_FORMED_TYPE_NAME_REGEX.matcher(aTypeName).matches();
    }

    public static boolean isWellFormedClassName(String aClassName) {
        return WELL_FORMED_CLASS_NAME_REGEX.matcher(aClassName).matches();
    }

    public static boolean isFormalGenericParameterName(String typeName) {
        return typeName.length() == 1;
    }

    public static boolean isWellFormedGenericTypeName(String aGenericTypeName) {
        return BmmDefinitions.isWellFormedTypeName(aGenericTypeName) && aGenericTypeName.indexOf(GENERIC_LEFT_DELIMITER.charValue()) > 0;
    }

    public static boolean isGenericTypeName(String aGenericTypeName) {
        return aGenericTypeName.indexOf(GENERIC_LEFT_DELIMITER.charValue()) > 0;
    }

    public static boolean isBmmVersionCompatible(String aSchemaBmmVersion) {
        return aSchemaBmmVersion.substring(0, aSchemaBmmVersion.indexOf(46)).equals(BMM_INTERNAL_VERSION.substring(0, BMM_INTERNAL_VERSION.indexOf(46)));
    }

    public static String createSchemaId(String aModelPublisher, String aSchemaName, String aModelRelease) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)aModelPublisher)) {
            builder.append("unknown");
        } else {
            builder.append(aModelPublisher);
        }
        builder.append("_");
        if (StringUtils.isEmpty((CharSequence)aSchemaName)) {
            builder.append("unknown");
        } else {
            builder.append(aSchemaName);
        }
        builder.append("_");
        if (StringUtils.isEmpty((CharSequence)aModelRelease)) {
            builder.append("unknown");
        } else {
            builder.append(aModelRelease);
        }
        return builder.toString().toLowerCase();
    }

    public static String packageBaseName(String aPackageName) {
        if (aPackageName.indexOf(PACKAGE_NAME_DELIMITER.charValue()) >= 0) {
            return aPackageName.substring(aPackageName.lastIndexOf(PACKAGE_NAME_DELIMITER.charValue()) + 1);
        }
        return aPackageName;
    }

    public static String publisherQualifiedRmClosureName(String aRmPublisher, String aRmClosureName) {
        return aRmPublisher + SCHEMA_ID_DELIMITER + BmmDefinitions.packageBaseName(aRmClosureName).toUpperCase();
    }

    public static String publisherQualifiedRmClosureKey(String aRmPublisher, String aRmClosureName) {
        return BmmDefinitions.publisherQualifiedRmClosureName(aRmPublisher, aRmClosureName).toLowerCase();
    }

    public static String rmClosureQualifiedClassName(String aRmClosureName, String aClassName) {
        return aRmClosureName + SCHEMA_ID_DELIMITER + aClassName;
    }

    public static List<String> typeNameAsFlatList(String aTypeName) {
        ArrayList<String> retVal = new ArrayList<String>();
        String cleanedType = aTypeName.replaceAll("\\s", "");
        boolean isGenType = false;
        int lpos = -1;
        int rpos = -1;
        if (cleanedType.indexOf(GENERIC_LEFT_DELIMITER.charValue()) > 0) {
            rpos = cleanedType.indexOf(GENERIC_LEFT_DELIMITER.charValue());
            isGenType = true;
        }
        if (rpos < 0) {
            retVal.add(aTypeName);
        } else {
            retVal.add(aTypeName.substring(0, rpos));
        }
        if (isGenType) {
            cleanedType = cleanedType.substring(rpos + 1);
            cleanedType = cleanedType.replaceAll("" + GENERIC_RIGHT_DELIMITER, "");
            String[] genericTypes = cleanedType.split("" + GENERIC_SEPARATOR);
            retVal.addAll(Arrays.asList(genericTypes));
        }
        return retVal;
    }

    public static String typeNameToClassKey(String aTypeName) {
        if (aTypeName.indexOf(GENERIC_LEFT_DELIMITER.charValue()) >= 0) {
            return aTypeName.substring(0, aTypeName.indexOf(GENERIC_LEFT_DELIMITER.charValue())).toUpperCase();
        }
        return aTypeName.toUpperCase();
    }

    public static List<String> genericParameterTypes(String aTypeName) {
        if (!BmmDefinitions.isWellFormedGenericTypeName(aTypeName)) {
            throw new IllegalArgumentException("Invalid generic type " + aTypeName);
        }
        ArrayList<String> retVal = new ArrayList<String>();
        String genericClause = aTypeName.substring(aTypeName.indexOf(GENERIC_LEFT_DELIMITER.charValue()) + 1, aTypeName.length() - 1);
        genericClause = genericClause.replaceAll("\\s", "");
        char[] chars = genericClause.toCharArray();
        int genericsLevel = 0;
        int startPosition = 0;
        for (int index = 0; index < chars.length; ++index) {
            if (chars[index] == GENERIC_LEFT_DELIMITER.charValue()) {
                ++genericsLevel;
            } else if (chars[index] == GENERIC_RIGHT_DELIMITER.charValue()) {
                --genericsLevel;
            }
            if (genericsLevel != 0) continue;
            if (chars[index] == GENERIC_SEPARATOR.charValue()) {
                retVal.add(genericClause.substring(startPosition, index));
                ++startPosition;
                continue;
            }
            if (index != chars.length - 1) continue;
            retVal.add(genericClause.substring(startPosition));
        }
        return retVal;
    }
}

