/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmEnumeration;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmPackageContainer;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmSchemaCore;
import org.openehr.bmm.core.BmmSimpleClass;
import org.openehr.bmm.core.BmmSimpleType;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.core.IBmmPackageContainer;
import org.openehr.bmm.core.IBmmSchemaCore;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class BmmModel
extends BmmPackageContainer
implements IBmmSchemaCore,
IBmmPackageContainer,
Serializable {
    private Map<String, BmmClass> classDefinitions;
    private IBmmSchemaCore bmmSchemaCore = new BmmSchemaCore();

    public BmmModel() {
        this.classDefinitions = new HashMap<String, BmmClass>();
    }

    public Map<String, BmmClass> getClassDefinitions() {
        return this.classDefinitions;
    }

    public void setClassDefinitions(Map<String, BmmClass> classDefinitions) {
        this.classDefinitions = classDefinitions;
    }

    public void addClassDefinition(BmmClass bmmClassDefinition) {
        this.classDefinitions.put(bmmClassDefinition.getName().toUpperCase(), bmmClassDefinition);
    }

    public void addClassDefinition(BmmClass bmmClassDefinition, BmmPackage packageDefinition) {
        if (this.getClassDefinition(bmmClassDefinition.getName()) == null) {
            this.addClassDefinition(bmmClassDefinition);
            packageDefinition.addClass(bmmClassDefinition);
            bmmClassDefinition.setBmmPackage(packageDefinition);
            bmmClassDefinition.setBmmModel(this);
        }
    }

    public BmmClass getClassDefinition(String typeName) {
        return this.classDefinitions.get(BmmDefinitions.typeNameToClassKey(typeName));
    }

    public IBmmSchemaCore getBmmSchemaCore() {
        return this.bmmSchemaCore;
    }

    public void setBmmSchemaCore(IBmmSchemaCore bmmSchemaCore) {
        this.bmmSchemaCore = bmmSchemaCore;
    }

    public List<String> getPrimitiveTypes() {
        ArrayList<String> primitives = new ArrayList<String>();
        this.classDefinitions.forEach((id, bmmClass) -> {
            if (bmmClass != null && bmmClass.isPrimitiveType()) {
                primitives.add((String)id);
            }
        });
        return primitives;
    }

    public List<String> getEnumerationTypes() {
        ArrayList<String> enumerations = new ArrayList<String>();
        this.classDefinitions.forEach((id, bmmClass) -> {
            if (bmmClass != null && bmmClass instanceof BmmEnumeration) {
                enumerations.add((String)id);
            }
        });
        return enumerations;
    }

    public BmmEnumeration<?> getEnumerationDefinition(String bmmEnumerationName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isMsConformantPropertyType(String bmmTypeName, String bmmPropertyName, String msPropertyName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Boolean hasPropertyAtPath(String typeName, String propertyPath) {
        return this.propertyAtPath(typeName, propertyPath) != null;
    }

    public BmmProperty propertyAtPath(String typeName, String propertyPath) {
        BmmClass bmmClass = this.getClassDefinition(typeName);
        if (bmmClass != null) {
            return this.propertyAtPath(bmmClass, new APathQuery(propertyPath).getPathSegments());
        }
        return null;
    }

    private BmmProperty propertyAtPath(BmmClass bmmClass, List<PathSegment> pathSegments) {
        BmmProperty result;
        block3: {
            block1: {
                String nodeName;
                block2: {
                    result = null;
                    nodeName = pathSegments.get(0).getNodeName();
                    if (!bmmClass.hasFlatPropertyWithName(nodeName).booleanValue()) break block1;
                    if (pathSegments.size() != 1) break block2;
                    result = bmmClass.getFlatProperties().get(nodeName);
                    break block3;
                }
                BmmClass bmmPropTypeClass = this.getClassDefinition(((BmmType)bmmClass.getFlatProperties().get(nodeName).getType()).getEffectiveType().typeBaseName());
                if (bmmPropTypeClass == null) break block3;
                result = this.propertyAtPath(bmmPropTypeClass, pathSegments.subList(1, pathSegments.size()));
                break block3;
            }
            for (String descClass : bmmClass.getImmediateDescendants()) {
                BmmProperty descClassProperty = this.propertyAtPath(this.getClassDefinition(descClass), pathSegments);
                if (descClassProperty == null) continue;
                result = descClassProperty;
                break;
            }
        }
        return result;
    }

    public List<String> getAllAncestorClasses(String bmmClassName) {
        LinkedHashMap<String, BmmClass> classMap = new LinkedHashMap<String, BmmClass>();
        BmmClass bmmClass = this.getClassDefinition(bmmClassName);
        this.populateAllAncestorClassMap(bmmClass, classMap);
        return new ArrayList<String>(classMap.keySet());
    }

    public Map<String, BmmClass> getAllAncestorClassObjects(BmmClass bmmClass) {
        LinkedHashMap<String, BmmClass> result = new LinkedHashMap<String, BmmClass>();
        this.populateAllAncestorClassMap(bmmClass, result);
        return result;
    }

    protected void populateAllAncestorClassMap(BmmClass bmmClass, Map<String, BmmClass> classMap) {
        bmmClass.getAncestors().forEach((className, typeDef) -> {
            classMap.put((String)className, typeDef.getBaseClass());
            this.populateAllAncestorClassMap(typeDef.getBaseClass(), classMap);
        });
    }

    public Map<String, BmmClass> getAllDescendantClassObjects(BmmClass bmmClass) {
        LinkedHashMap<String, BmmClass> result = new LinkedHashMap<String, BmmClass>();
        this.getClassDefinitions().forEach((className, classDef) -> {
            Map<String, BmmClass> allAncestors = this.getAllAncestorClassObjects((BmmClass)classDef);
            if (allAncestors.containsKey(bmmClass.getName())) {
                result.put(classDef.getName(), (BmmClass)classDef);
            }
        });
        return result;
    }

    public BmmSimpleClass getAnyClassDefinition() {
        if (this.getClassDefinition("Any") != null) {
            return (BmmSimpleClass)this.getClassDefinition("Any");
        }
        BmmSimpleClass result = new BmmSimpleClass("Any", null, false);
        result.setAbstract(true);
        result.setDocumentation("Root class of type system");
        return result;
    }

    public BmmSimpleType getAnyTypeDefinition() {
        return new BmmSimpleType(this.getAnyClassDefinition());
    }

    public boolean descendantOf(String descendantType, String ancestorType) {
        return this.getClassDefinition(descendantType).findAllAncestors().contains(ancestorType);
    }

    public boolean doesTypeConformTo(String descendantType, String ancestorType) {
        throw new UnsupportedOperationException("Not yet implememented");
    }

    public Set<String> suppliers(String typeName) {
        BmmClass bmmClass = this.getClassDefinition(typeName);
        HashSet<String> result = new HashSet<String>();
        for (BmmProperty bmmProperty : bmmClass.getFlatProperties().values()) {
            List<String> ftl = ((BmmType)bmmProperty.getType()).getFlattenedTypeList();
            result.addAll(ftl);
            for (String type : ftl) {
                result.addAll(this.getClassDefinition(type).getImmediateDescendants());
            }
        }
        return result;
    }

    public Set<String> supplierClosure(String typeName) {
        BmmClass bmmClass = this.getClassDefinition(typeName);
        HashSet<String> result = new HashSet<String>();
        HashSet<String> closureTypesDone = new HashSet<String>();
        closureTypesDone.add(bmmClass.getName());
        Set<String> immediateSuppliers = this.suppliers(typeName);
        result.addAll(immediateSuppliers);
        for (String immSupp : immediateSuppliers) {
            if (closureTypesDone.contains(immSupp)) continue;
            result.addAll(this.supplierClosure(immSupp));
            closureTypesDone.add(immSupp);
        }
        return result;
    }

    public String effectivePropertyType(String typeName, String propertyName) {
        BmmClass bmmClass = this.getClassDefinition(typeName);
        if (bmmClass == null) {
            return "UNKNOWN";
        }
        return bmmClass.effectivePropertyType(propertyName);
    }

    @Override
    public String getRmPublisher() {
        return this.bmmSchemaCore.getRmPublisher();
    }

    @Override
    public void setRmPublisher(String rmPublisher) {
        this.bmmSchemaCore.setRmPublisher(rmPublisher);
    }

    @Override
    public String getRmRelease() {
        return this.bmmSchemaCore.getRmRelease();
    }

    @Override
    public void setRmRelease(String rmRelease) {
        this.bmmSchemaCore.setRmRelease(rmRelease);
    }

    @Override
    public String getSchemaName() {
        return this.bmmSchemaCore.getSchemaName();
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.bmmSchemaCore.setSchemaName(schemaName);
    }

    @Override
    public String getSchemaRevision() {
        return this.bmmSchemaCore.getSchemaRevision();
    }

    @Override
    public void setSchemaRevision(String schemaRevision) {
        this.bmmSchemaCore.setSchemaRevision(schemaRevision);
    }

    @Override
    public String getSchemaLifecycleState() {
        return this.bmmSchemaCore.getSchemaLifecycleState();
    }

    @Override
    public void setSchemaLifecycleState(String schemaLifecycleState) {
        this.bmmSchemaCore.setSchemaLifecycleState(schemaLifecycleState);
    }

    @Override
    public String getSchemaAuthor() {
        return this.bmmSchemaCore.getSchemaAuthor();
    }

    @Override
    public void setSchemaAuthor(String schemaAuthor) {
        this.bmmSchemaCore.setSchemaAuthor(schemaAuthor);
    }

    @Override
    public String getSchemaDescription() {
        return this.bmmSchemaCore.getSchemaDescription();
    }

    @Override
    public void setSchemaDescription(String schemaDescription) {
        this.bmmSchemaCore.setSchemaDescription(schemaDescription);
    }

    @Override
    public List<String> getSchemaContributors() {
        return this.bmmSchemaCore.getSchemaContributors();
    }

    @Override
    public void setSchemaContributors(List<String> schemaContributors) {
        this.bmmSchemaCore.setSchemaContributors(schemaContributors);
    }

    @Override
    public String getArchetypeParentClass() {
        return this.bmmSchemaCore.getArchetypeParentClass();
    }

    @Override
    public void setArchetypeParentClass(String archetypeParentClass) {
        this.bmmSchemaCore.setArchetypeParentClass(archetypeParentClass);
    }

    @Override
    public String getArchetypeDataValueParentClass() {
        return this.bmmSchemaCore.getArchetypeDataValueParentClass();
    }

    @Override
    public void setArchetypeDataValueParentClass(String archetypeDataValueParentClass) {
        this.bmmSchemaCore.setArchetypeDataValueParentClass(archetypeDataValueParentClass);
    }

    @Override
    public List<String> getArchetypeRmClosurePackages() {
        return this.bmmSchemaCore.getArchetypeRmClosurePackages();
    }

    @Override
    public void setArchetypeRmClosurePackages(List<String> rmClosurePackages) {
        this.bmmSchemaCore.setArchetypeRmClosurePackages(rmClosurePackages);
    }

    @Override
    public void addArchetypeRmClosurePackage(String rmClosurePackage) {
        this.bmmSchemaCore.addArchetypeRmClosurePackage(rmClosurePackage);
    }

    @Override
    public String getArchetypeVisualizeDescendantsOf() {
        return this.bmmSchemaCore.getArchetypeVisualizeDescendantsOf();
    }

    @Override
    public void setArchetypeVisualizeDescendantsOf(String archetypeVisualizeDescendantsOf) {
        this.bmmSchemaCore.setArchetypeVisualizeDescendantsOf(archetypeVisualizeDescendantsOf);
    }

    @Override
    public String getSchemaId() {
        return this.bmmSchemaCore.getSchemaId();
    }

    @Override
    public String getModelName() {
        return this.bmmSchemaCore.getModelName();
    }

    @Override
    public void setModelName(String modelName) {
        this.bmmSchemaCore.setModelName(modelName);
    }
}

