/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmValidation;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageLogger;

public class CreatedSchemaValidation
implements BmmValidation {
    @Override
    public void validate(BmmValidationResult validationResult, BmmRepository repository, MessageLogger logger, PBmmSchema schema) {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.addAll(schema.getPackages().keySet());
        schema.getPackages().keySet().forEach(name1 -> {
            boolean invalidSiblings = packageNames.stream().anyMatch(name2 -> !name1.equalsIgnoreCase((String)name2) && (name1.startsWith((String)name2) || name2.startsWith((String)name1)));
            if (invalidSiblings) {
                logger.addError((MessageCode)BmmMessageIds.EC_ILLEGAL_TOP_LEVEL_SIBLING_PACKAGES, new Object[]{schema.getSchemaId()});
            }
        });
        schema.doRecursivePackages(persistedBmmPackage -> {
            if (!schema.getPackages().containsKey(persistedBmmPackage.getName()) && persistedBmmPackage.getName().indexOf(BmmDefinitions.PACKAGE_NAME_DELIMITER.charValue()) >= 0) {
                logger.addError((MessageCode)BmmMessageIds.EC_ILLEGAL_QUALIFIED_PACKAGE_NAME, new Object[]{schema.getSchemaId(), persistedBmmPackage.getName()});
            }
            for (String persistedBmmClass : persistedBmmPackage.getClasses()) {
                if (StringUtils.isEmpty((CharSequence)persistedBmmClass)) {
                    logger.addError((MessageCode)BmmMessageIds.ec_BMM_class_name_empty, new Object[]{schema.getSchemaId(), persistedBmmPackage.getName()});
                    continue;
                }
                if (schema.hasClassOrPrimitiveDefinition(persistedBmmClass)) continue;
                logger.addError((MessageCode)BmmMessageIds.ec_BMM_class_not_in_definitions, new Object[]{schema.getSchemaId(), persistedBmmClass, persistedBmmPackage.getName()});
            }
        });
        if (!logger.hasErrors()) {
            logger.addInfo((MessageCode)BmmMessageIds.SCHEMA_CREATED, new Object[]{schema.getSchemaId(), "" + schema.getPrimitiveTypes().size(), "" + schema.getClassDefinitions().size()});
        }
    }
}

