/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.validators;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.persistence.validation.BmmMessageIds;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmValidation;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.bmm.v2.validation.validators.PropertyValidator;
import org.openehr.bmm.v2.validation.validators.ValidatorBase;
import org.openehr.utils.message.MessageLogger;

public class ClassesValidator
extends ValidatorBase
implements BmmValidation {
    private BmmValidationResult validationResult;
    private BmmRepository repository;
    private PBmmSchema schema;
    private PropertyValidator propertyValidator;

    @Override
    public void validate(BmmValidationResult validationResult, BmmRepository repository, MessageLogger logger, PBmmSchema schema) {
        this.setLogger(logger);
        this.validationResult = validationResult;
        this.repository = repository;
        this.schema = schema;
        this.propertyValidator = new PropertyValidator(logger, schema);
        schema.doAllClasses(pBmmClass -> this.validateClass((PBmmClass)((Object)pBmmClass)));
    }

    public void validateClass(PBmmClass pBmmClass) {
        pBmmClass.getAncestorTypeNames().forEach(ancestorClassName -> {
            if (StringUtils.isEmpty((CharSequence)ancestorClassName)) {
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_ANCESTOR_NAME_EMPTY, pBmmClass.getSourceSchemaId(), pBmmClass.getName());
            } else if (!ancestorClassName.equalsIgnoreCase("Any") && this.schema.findClassOrPrimitiveDefinition(BmmDefinitions.typeNameToClassKey(ancestorClassName)) == null) {
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_ANCESTOR_DOES_NOT_EXIST, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), ancestorClassName);
            }
        });
        if (!this.logger.hasErrors()) {
            this.validateGenericParameters(pBmmClass);
        }
        for (PBmmProperty property : pBmmClass.getProperties().values()) {
            this.propertyValidator.validateProperty(pBmmClass, property);
        }
    }

    private void validateGenericParameters(PBmmClass pBmmClass) {
        if (pBmmClass.isGeneric()) {
            Map<String, PBmmGenericParameter> genericParameterDefinitions = pBmmClass.getGenericParameterDefs();
            for (PBmmGenericParameter pBmmGenericParameter : genericParameterDefinitions.values()) {
                String conformsToType = pBmmGenericParameter.getConformsToType();
                if (conformsToType == null || this.schema.hasClassOrPrimitiveDefinition(conformsToType)) continue;
                this.addValidityError(this.schema, pBmmClass.getSourceSchemaId(), BmmMessageIds.EC_GENERIC_PARAMETER_CONSTRAINT_DOES_NOT_EXIST, pBmmClass.getSourceSchemaId(), pBmmClass.getName(), pBmmGenericParameter.getName(), conformsToType);
            }
        }
    }
}

