/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.Map;
import java.util.TreeMap;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;

public class CanonicalPackagesGenerator {
    public Map<String, PBmmPackage> generateCanonicalPackages(PBmmSchema schema) {
        TreeMap<String, PBmmPackage> canonicalPackages = new TreeMap<String, PBmmPackage>(String.CASE_INSENSITIVE_ORDER);
        PBmmPackage childPackage = null;
        String childPackageKey = null;
        Map<String, PBmmPackage> packageContainer = null;
        for (PBmmPackage topPackage : schema.getPackages().values()) {
            if (topPackage.getName().indexOf(BmmDefinitions.PACKAGE_NAME_DELIMITER.charValue()) >= 0) {
                packageContainer = canonicalPackages;
                String[] packagePathComponents = topPackage.getName().split("\\.");
                for (int index = 0; index < packagePathComponents.length; ++index) {
                    childPackageKey = packagePathComponents[index].toUpperCase();
                    if (packageContainer.containsKey(childPackageKey)) {
                        childPackage = (PBmmPackage)((Object)packageContainer.get(childPackageKey));
                    } else {
                        childPackage = new PBmmPackage(packagePathComponents[index]);
                        packageContainer.put(childPackageKey, childPackage);
                    }
                    packageContainer = childPackage.getPackages();
                }
                childPackage.setClassesAndPackagesFrom(topPackage);
                continue;
            }
            canonicalPackages.put(topPackage.getName().toUpperCase(), topPackage);
        }
        return canonicalPackages;
    }
}

