/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.ArrayList;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.bmm.v2.validation.converters.BmmClassCreator;
import org.openehr.bmm.v2.validation.converters.ProcessClassesInOrder;

public class BmmModelCreator {
    private BmmClassCreator classCreator = new BmmClassCreator();

    public BmmModel create(BmmValidationResult validationResult) {
        PBmmSchema schema = validationResult.getSchemaWithMergedIncludes();
        BmmModel model = new BmmModel();
        model.setRmPublisher(schema.getRmPublisher());
        model.setRmRelease(schema.getRmRelease());
        model.setModelName(schema.getModelName());
        model.setSchemaName(schema.getSchemaName());
        model.setSchemaRevision(schema.getSchemaRevision());
        model.setSchemaAuthor(schema.getSchemaAuthor());
        model.setSchemaDescription(schema.getSchemaDescription());
        model.setSchemaLifecycleState(schema.getSchemaLifecycleState());
        model.setSchemaContributors(schema.getSchemaContributors() == null ? new ArrayList<String>() : new ArrayList<String>(schema.getSchemaContributors()));
        for (PBmmPackage pBmmPackage : validationResult.getCanonicalPackages().values()) {
            BmmPackage bmmPackage = this.createBmmPackageDefinition(pBmmPackage, null, null);
            model.addPackage(bmmPackage);
            pBmmPackage.doRecursiveClasses((p, s) -> {
                BmmClass bmmClass;
                PBmmClass persistedBmmClass = schema.findClassOrPrimitiveDefinition((String)s);
                if (persistedBmmClass != null && (bmmClass = this.classCreator.createBmmClass(persistedBmmClass)) != null && bmmPackage != null) {
                    if (schema.getPrimitiveTypes().get(bmmClass.getName()) != null) {
                        bmmClass.setPrimitiveType(true);
                    }
                    if (persistedBmmClass.isOverride() != null && persistedBmmClass.isOverride().booleanValue()) {
                        bmmClass.setOverride(true);
                    }
                    model.addClassDefinition(bmmClass, bmmPackage);
                }
            });
        }
        model.setArchetypeParentClass(schema.getArchetypeParentClass());
        model.setArchetypeDataValueParentClass(schema.getArchetypeDataValueParentClass());
        model.setArchetypeVisualizeDescendantsOf(schema.getArchetypeVisualizeDescendantsOf());
        model.setArchetypeRmClosurePackages(schema.getArchetypeRmClosurePackages() == null ? new ArrayList<String>() : new ArrayList<String>(schema.getArchetypeRmClosurePackages()));
        ProcessClassesInOrder processClassesInOrder = new ProcessClassesInOrder();
        processClassesInOrder.doAllClassesInOrder(schema, bmmClass -> this.classCreator.populateBmmClass((PBmmClass)((Object)bmmClass), model), new ArrayList<PBmmClass>(schema.getPrimitiveTypes().values()));
        processClassesInOrder.doAllClassesInOrder(schema, bmmClass -> this.classCreator.populateBmmClass((PBmmClass)((Object)bmmClass), model), new ArrayList<PBmmClass>(schema.getClassDefinitions().values()));
        return model;
    }

    private BmmPackage createBmmPackageDefinition(PBmmPackage p, PBmmPackage parent, BmmPackage parentPackageDefinition) {
        BmmPackage bmmPackageDefinition = new BmmPackage(p.getName());
        bmmPackageDefinition.setDocumentation(p.getDocumentation());
        if (parent != null) {
            bmmPackageDefinition.appendToPath(parent.getName());
            bmmPackageDefinition.setParent(parentPackageDefinition);
        }
        bmmPackageDefinition.appendToPath(p.getName());
        p.getPackages().values().forEach(childPackage -> {
            BmmPackage bmmChildPackageDefinition = this.createBmmPackageDefinition((PBmmPackage)((Object)childPackage), p, bmmPackageDefinition);
            bmmPackageDefinition.addPackage(bmmChildPackageDefinition);
        });
        return bmmPackageDefinition;
    }
}

