/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence.odin;

import com.nedap.archie.adlparser.antlr.odinLexer;
import com.nedap.archie.adlparser.antlr.odinParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.antlr.errors.ArchieErrorListener;
import com.nedap.archie.serializer.odin.OdinToJsonConverter;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.persistence.jackson.BmmJacksonUtil;

public class BmmOdinParser {
    public static PBmmSchema convert(odinParser.Odin_textContext odin) {
        try {
            String json = new OdinToJsonConverter().convert(odin);
            return (PBmmSchema)((Object)BmmJacksonUtil.getObjectMapper().readValue(json, PBmmSchema.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PBmmSchema convert(InputStream odin) throws IOException {
        odinLexer lexer = new odinLexer(CharStreams.fromStream((InputStream)odin));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        odinParser parser = new odinParser((TokenStream)tokens);
        ANTLRParserErrors errors = new ANTLRParserErrors();
        ArchieErrorListener listener = new ArchieErrorListener(errors);
        parser.addErrorListener((ANTLRErrorListener)listener);
        PBmmSchema converted = BmmOdinParser.convert(parser.odin_text());
        if (errors.hasErrors()) {
            throw new RuntimeException("errors parsing ODIN file: " + errors);
        }
        return converted;
    }

    public static PBmmSchema convert(String odin) {
        odinLexer lexer = new odinLexer((CharStream)CharStreams.fromString((String)odin));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        odinParser parser = new odinParser((TokenStream)tokens);
        ANTLRParserErrors errors = new ANTLRParserErrors();
        ArchieErrorListener listener = new ArchieErrorListener(errors);
        parser.addErrorListener((ANTLRErrorListener)listener);
        PBmmSchema converted = BmmOdinParser.convert(parser.odin_text());
        if (errors.hasErrors()) {
            throw new RuntimeException("errors parsing ODIN file: " + errors);
        }
        return converted;
    }
}

