/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openehr.bmm.v2.persistence.PBmmBase;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmType;

public class PBmmClass
extends PBmmBase {
    private String documentation;
    private String name;
    private List<String> ancestors;
    private Map<String, PBmmType> ancestorDefs;
    private Map<String, PBmmProperty> properties;
    private Boolean isAbstract;
    private Boolean isOverride;
    private Map<String, PBmmGenericParameter> genericParameterDefs;
    private transient String sourceSchemaId;

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAncestors() {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<String>();
        }
        return this.ancestors;
    }

    @JsonIgnore
    public List<String> getAncestorTypeNames() {
        if (this.ancestorDefs != null && !this.ancestorDefs.isEmpty()) {
            return this.ancestorDefs.values().stream().map(type -> type.asTypeString()).collect(Collectors.toList());
        }
        if (this.ancestors != null) {
            return this.ancestors;
        }
        return new ArrayList<String>();
    }

    public void setAncestors(List<String> ancestors) {
        this.ancestors = ancestors;
    }

    public Map<String, PBmmProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, PBmmProperty>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, PBmmProperty> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="is_abstract")
    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    @JsonProperty(value="is_override")
    public Boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(Boolean override) {
        this.isOverride = override;
    }

    public Map<String, PBmmGenericParameter> getGenericParameterDefs() {
        if (this.genericParameterDefs == null) {
            this.genericParameterDefs = new LinkedHashMap<String, PBmmGenericParameter>();
        }
        return this.genericParameterDefs;
    }

    public void setGenericParameterDefs(Map<String, PBmmGenericParameter> genericParameterDefs) {
        this.genericParameterDefs = genericParameterDefs;
    }

    @JsonIgnore
    public boolean isGeneric() {
        return this.getGenericParameterDefs() != null && this.getGenericParameterDefs().size() > 0;
    }

    @JsonIgnore
    public String getSourceSchemaId() {
        return this.sourceSchemaId;
    }

    public void setSourceSchemaId(String sourceSchemaId) {
        this.sourceSchemaId = sourceSchemaId;
    }

    public Map<String, PBmmType> getAncestorDefs() {
        return this.ancestorDefs;
    }

    public void setAncestorDefs(Map<String, PBmmType> ancestorDefs) {
        this.ancestorDefs = ancestorDefs;
    }
}

