/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmEnumeration;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmPackageContainer;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmSchemaCore;
import org.openehr.bmm.core.IBmmPackageContainer;
import org.openehr.bmm.core.IBmmSchemaCore;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class BmmModel
extends BmmPackageContainer
implements IBmmSchemaCore,
IBmmPackageContainer,
Serializable {
    private Map<String, BmmClass> classDefinitions;
    private IBmmSchemaCore bmmSchemaCore = new BmmSchemaCore();

    public BmmModel() {
        this.classDefinitions = new HashMap<String, BmmClass>();
    }

    public Map<String, BmmClass> getClassDefinitions() {
        return this.classDefinitions;
    }

    public void setClassDefinitions(Map<String, BmmClass> classDefinitions) {
        this.classDefinitions = classDefinitions;
    }

    public void addClassDefinition(BmmClass bmmClassDefinition) {
        this.classDefinitions.put(bmmClassDefinition.getName().toUpperCase(), bmmClassDefinition);
    }

    public void addClassDefinition(BmmClass bmmClassDefinition, BmmPackage packageDefinition) {
        if (this.getClassDefinition(bmmClassDefinition.getName()) == null) {
            this.addClassDefinition(bmmClassDefinition);
            packageDefinition.addClass(bmmClassDefinition);
            bmmClassDefinition.setBmmPackage(packageDefinition);
            bmmClassDefinition.setBmmModel(this);
        }
    }

    public BmmClass getClassDefinition(String bmmClassName) {
        return this.classDefinitions.get(bmmClassName.toUpperCase());
    }

    public IBmmSchemaCore getBmmSchemaCore() {
        return this.bmmSchemaCore;
    }

    public void setBmmSchemaCore(IBmmSchemaCore bmmSchemaCore) {
        this.bmmSchemaCore = bmmSchemaCore;
    }

    public List<String> getPrimitiveTypes() {
        ArrayList<String> primitives = new ArrayList<String>();
        this.classDefinitions.forEach((id, bmmClass) -> {
            if (bmmClass != null && bmmClass.isPrimitiveType()) {
                primitives.add((String)id);
            }
        });
        return primitives;
    }

    public List<String> getEnumerationTypes() {
        ArrayList<String> enumerations = new ArrayList<String>();
        this.classDefinitions.forEach((id, bmmClass) -> {
            if (bmmClass != null && bmmClass instanceof BmmEnumeration) {
                enumerations.add((String)id);
            }
        });
        return enumerations;
    }

    public BmmEnumeration<?> getEnumerationDefinition(String bmmEnumerationName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BmmProperty getPropertyDefinition(String bmmClassName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean isMsConformantPropertyType(String bmmTypeName, String bmmPropertyName, String msPropertyName) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public BmmProperty getPropertyDefinitionAtPath(String propertyPath) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public List<String> getAllAncestorClasses(String bmmClassName) {
        LinkedHashMap<String, BmmClass> classMap = new LinkedHashMap<String, BmmClass>();
        BmmClass bmmClass = this.getClassDefinition(bmmClassName);
        this.populateAllAncestorClassMap(bmmClass, classMap);
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(classMap.keySet());
        return classNames;
    }

    public Map<String, BmmClass> getAllAncestorClassObjects(BmmClass bmmClass) {
        LinkedHashMap<String, BmmClass> classMap = new LinkedHashMap<String, BmmClass>();
        this.populateAllAncestorClassMap(bmmClass, classMap);
        ArrayList classNames = new ArrayList();
        classNames.addAll(classMap.keySet());
        return classMap;
    }

    protected void populateAllAncestorClassMap(BmmClass bmmClass, Map<String, BmmClass> classMap) {
        bmmClass.getAncestors().forEach((className, classDef) -> {
            classMap.put((String)className, (BmmClass)classDef);
            this.populateAllAncestorClassMap((BmmClass)classDef, classMap);
        });
    }

    public Map<String, BmmClass> getAllDescendantClassObjects(BmmClass bmmClass) {
        LinkedHashMap<String, BmmClass> descendants = new LinkedHashMap<String, BmmClass>();
        this.getClassDefinitions().forEach((className, classDef) -> {
            Map<String, BmmClass> allAncestors = this.getAllAncestorClassObjects((BmmClass)classDef);
            if (allAncestors.containsKey(bmmClass.getName())) {
                descendants.put(classDef.getName(), (BmmClass)classDef);
            }
        });
        return descendants;
    }

    public BmmClass getAnyClassDefinition() {
        if (this.getClassDefinition("Any") != null) {
            return this.getClassDefinition("Any");
        }
        BmmClass result = new BmmClass("Any");
        result.setAbstract(true);
        result.setDocumentation("Root class of type system");
        return result;
    }

    public boolean doesTypeConformTo(String descendantType, String ancestorType) {
        throw new UnsupportedOperationException("Not yet implememented");
    }

    @Override
    public String getRmPublisher() {
        return this.bmmSchemaCore.getRmPublisher();
    }

    @Override
    public void setRmPublisher(String rmPublisher) {
        this.bmmSchemaCore.setRmPublisher(rmPublisher);
    }

    @Override
    public String getRmRelease() {
        return this.bmmSchemaCore.getRmRelease();
    }

    @Override
    public void setRmRelease(String rmRelease) {
        this.bmmSchemaCore.setRmRelease(rmRelease);
    }

    @Override
    public String getSchemaName() {
        return this.bmmSchemaCore.getSchemaName();
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.bmmSchemaCore.setSchemaName(schemaName);
    }

    @Override
    public String getSchemaRevision() {
        return this.bmmSchemaCore.getSchemaRevision();
    }

    @Override
    public void setSchemaRevision(String schemaRevision) {
        this.bmmSchemaCore.setSchemaRevision(schemaRevision);
    }

    @Override
    public String getSchemaLifecycleState() {
        return this.bmmSchemaCore.getSchemaLifecycleState();
    }

    @Override
    public void setSchemaLifecycleState(String schemaLifecycleState) {
        this.bmmSchemaCore.setSchemaLifecycleState(schemaLifecycleState);
    }

    @Override
    public String getSchemaAuthor() {
        return this.bmmSchemaCore.getSchemaAuthor();
    }

    @Override
    public void setSchemaAuthor(String schemaAuthor) {
        this.bmmSchemaCore.setSchemaAuthor(schemaAuthor);
    }

    @Override
    public String getSchemaDescription() {
        return this.bmmSchemaCore.getSchemaDescription();
    }

    @Override
    public void setSchemaDescription(String schemaDescription) {
        this.bmmSchemaCore.setSchemaDescription(schemaDescription);
    }

    @Override
    public List<String> getSchemaContributors() {
        return this.bmmSchemaCore.getSchemaContributors();
    }

    @Override
    public void setSchemaContributors(List<String> schemaContributors) {
        this.bmmSchemaCore.setSchemaContributors(schemaContributors);
    }

    @Override
    public String getArchetypeParentClass() {
        return this.bmmSchemaCore.getArchetypeParentClass();
    }

    @Override
    public void setArchetypeParentClass(String archetypeParentClass) {
        this.bmmSchemaCore.setArchetypeParentClass(archetypeParentClass);
    }

    @Override
    public String getArchetypeDataValueParentClass() {
        return this.bmmSchemaCore.getArchetypeDataValueParentClass();
    }

    @Override
    public void setArchetypeDataValueParentClass(String archetypeDataValueParentClass) {
        this.bmmSchemaCore.setArchetypeDataValueParentClass(archetypeDataValueParentClass);
    }

    @Override
    public List<String> getArchetypeRmClosurePackages() {
        return this.bmmSchemaCore.getArchetypeRmClosurePackages();
    }

    @Override
    public void setArchetypeRmClosurePackages(List<String> rmClosurePackages) {
        this.bmmSchemaCore.setArchetypeRmClosurePackages(rmClosurePackages);
    }

    @Override
    public void addArchetypeRmClosurePackage(String rmClosurePackage) {
        this.bmmSchemaCore.addArchetypeRmClosurePackage(rmClosurePackage);
    }

    @Override
    public String getArchetypeVisualizeDescendantsOf() {
        return this.bmmSchemaCore.getArchetypeVisualizeDescendantsOf();
    }

    @Override
    public void setArchetypeVisualizeDescendantsOf(String archetypeVisualizeDescendantsOf) {
        this.bmmSchemaCore.setArchetypeVisualizeDescendantsOf(archetypeVisualizeDescendantsOf);
    }

    @Override
    public String getSchemaId() {
        return this.bmmSchemaCore.getSchemaId();
    }

    @Override
    public String getModelName() {
        return this.bmmSchemaCore.getModelName();
    }

    @Override
    public void setModelName(String modelName) {
        this.bmmSchemaCore.setModelName(modelName);
    }

    public String effectivePropertyType(String typeName, String propertyName) {
        BmmClass bmmClass = this.getClassDefinition(BmmDefinitions.typeNameToClassKey(typeName));
        if (bmmClass == null) {
            return "UNKNOWN";
        }
        return bmmClass.effectivePropertyType(propertyName);
    }
}

