/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmType;

public class BmmGenericType
extends BmmType
implements Serializable {
    public List<BmmType> genericParameters = new ArrayList<BmmType>();
    public BmmGenericClass baseClass;

    public List<BmmType> getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(List<BmmType> genericParameters) {
        this.genericParameters = genericParameters;
    }

    public void addGenericParameter(BmmType genericParameter) {
        this.genericParameters.add(genericParameter);
    }

    @Override
    public BmmGenericClass getBaseClass() {
        return this.baseClass;
    }

    public void setBaseClass(BmmGenericClass baseClass) {
        this.baseClass = baseClass;
    }

    @Override
    public String getTypeName() {
        StringBuilder builder = new StringBuilder();
        if (this.baseClass != null) {
            builder.append(this.baseClass.getName());
            builder.append("<");
            builder.append(this.genericParameters.stream().map(t -> t.getTypeName()).collect(Collectors.joining(",")));
            builder.append(">");
        } else {
            builder.append("No base class defined for type");
        }
        return builder.toString();
    }

    @Override
    public String toDisplayString() {
        return this.getTypeName();
    }
}

