/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmGenericParameter;

public class BmmGenericClass
extends BmmClass
implements Serializable {
    private Map<String, BmmGenericParameter> genericParameters = new LinkedHashMap<String, BmmGenericParameter>();

    public BmmGenericClass() {
    }

    public BmmGenericClass(String name) {
        this();
        this.setName(name);
    }

    public List<BmmGenericParameter> getGenericParameters() {
        ArrayList<BmmGenericParameter> parameters = new ArrayList<BmmGenericParameter>();
        parameters.addAll(this.genericParameters.values());
        return parameters;
    }

    public Map<String, BmmGenericParameter> getGenericParameterIndex() {
        return this.genericParameters;
    }

    public void setGenericParameters(List<BmmGenericParameter> parameters) {
        this.genericParameters.clear();
        parameters.forEach(param -> this.genericParameters.put(param.getName().toUpperCase(), (BmmGenericParameter)param));
    }

    public void addGenericParameter(BmmGenericParameter genericParameter) {
        this.genericParameters.put(genericParameter.getName().toUpperCase(), genericParameter);
    }

    public BmmGenericParameter getGenericParameter(String genericParameterName) {
        return this.genericParameters.get(genericParameterName.toUpperCase());
    }

    public BmmGenericParameter removeGenericParameter(BmmGenericParameter genericParameter) {
        return this.genericParameters.remove(genericParameter.getName().toUpperCase());
    }

    public BmmGenericParameter removeGenericParameter(String parameterName) {
        return this.genericParameters.remove(parameterName.toUpperCase());
    }

    public List<String> getSuppliers() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getTypeSignature() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getTypeName() {
        List<BmmGenericParameter> params = this.getGenericParameters();
        String paramString = params.stream().map(i -> i.getName()).collect(Collectors.joining(", "));
        StringBuilder builder = new StringBuilder(this.getName()).append("<").append(paramString).append(">");
        return builder.toString();
    }

    @Override
    public BmmGenericClass duplicate() {
        BmmGenericClass target = (BmmGenericClass)super.duplicate();
        target.setGenericParameters(this.getGenericParameters());
        return target;
    }
}

