/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmClassifier;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmType;

public class BmmClass
extends BmmClassifier
implements Serializable {
    private String name;
    private Map<String, BmmClass> ancestors;
    private BmmPackage bmmPackage;
    private BmmModel bmmModel;
    private Map<String, BmmProperty> properties = new LinkedHashMap<String, BmmProperty>();
    private String sourceSchemaId;
    private List<String> immediateDescendants;
    private boolean isAbstract;
    private boolean isPrimitiveType;
    private boolean isOverride;
    private BmmClass flattenedClassCache;

    public BmmClass() {
        this.ancestors = new LinkedHashMap<String, BmmClass>();
        this.immediateDescendants = new ArrayList<String>();
        this.properties = new LinkedHashMap<String, BmmProperty>();
    }

    public BmmClass(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, BmmClass> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(Map<String, BmmClass> ancestors) {
        this.ancestors = ancestors;
    }

    public void addAncestor(String name, BmmClass ancestor) {
        this.ancestors.put(name, ancestor);
    }

    public void addAncestor(BmmClass ancestor) {
        this.ancestors.put(ancestor.getName(), ancestor);
    }

    public BmmPackage getPackage() {
        return this.bmmPackage;
    }

    public void setPackage(BmmPackage bmmPackage) {
        this.bmmPackage = bmmPackage;
    }

    public Map<String, BmmProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, BmmProperty> properties) {
        this.properties = properties;
    }

    public void addProperty(BmmProperty property) {
        this.properties.put(property.getName(), property);
    }

    public String getSourceSchemaId() {
        return this.sourceSchemaId;
    }

    public void setSourceSchemaId(String sourceSchemaId) {
        this.sourceSchemaId = sourceSchemaId;
    }

    public List<String> getImmediateDescendants() {
        return this.immediateDescendants;
    }

    public void setImmediateDescendants(List<String> immediateDescendants) {
        this.immediateDescendants = immediateDescendants;
    }

    public void addImmediateDescendant(String immediateDecendant) {
        this.immediateDescendants.add(immediateDecendant);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType;
    }

    public void setPrimitiveType(boolean primitiveType) {
        this.isPrimitiveType = primitiveType;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean override) {
        this.isOverride = override;
    }

    public List<String> findAllAncestors() {
        ArrayList<String> allAncestors = new ArrayList<String>();
        Map<String, BmmClass> ancestors = this.getAncestors();
        allAncestors.addAll(ancestors.keySet());
        for (BmmClass ancestor : ancestors.values()) {
            allAncestors.addAll(ancestor.findAllAncestors());
        }
        return allAncestors;
    }

    public List<String> findAllDescendants() {
        ArrayList<String> allDescendants = new ArrayList<String>();
        List<String> descendants = this.getImmediateDescendants();
        allDescendants.addAll(descendants);
        for (String descendant : descendants) {
            BmmClass classDefinition = this.getBmmModel().getClassDefinition(descendant);
            if (classDefinition == null) continue;
            allDescendants.addAll(classDefinition.findAllDescendants());
        }
        return allDescendants;
    }

    public List<String> findSuppliers() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<String> findSuppliersNonPrimitive() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<String> findSupplierClosure() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getPackagePath() {
        if (this.bmmPackage != null) {
            return this.bmmPackage.getPath();
        }
        return null;
    }

    public String getClassPath() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<Map<String, BmmProperty<BmmType>>> getFlatProperties() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public BmmClass getBaseClass() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    public BmmPackage getBmmPackage() {
        return this.bmmPackage;
    }

    public void setBmmPackage(BmmPackage bmmPackage) {
        this.bmmPackage = bmmPackage;
    }

    public BmmModel getBmmModel() {
        return this.bmmModel;
    }

    public void setBmmModel(BmmModel bmmModel) {
        this.bmmModel = bmmModel;
    }

    public BmmClass flattenBmmClass() {
        if (this.flattenedClassCache != null) {
            return this.flattenedClassCache;
        }
        Map<String, BmmClass> ancestorMap = this.getAncestors();
        if (ancestorMap.size() == 0) {
            this.flattenedClassCache = this.duplicate();
        } else {
            BmmClass target = this.duplicate();
            ancestorMap.forEach((ancestorName, ancestor) -> this.populateTarget((BmmClass)ancestor, target));
            this.flattenedClassCache = target;
        }
        return this.flattenedClassCache;
    }

    public String effectivePropertyType(String propertyName) {
        BmmProperty property = this.flattenBmmClass().getProperties().get(propertyName);
        if (property != null) {
            return ((BmmClassifier)property.getType()).getTypeName();
        }
        return "UNKNOWN";
    }

    protected void populateTarget(BmmClass source, BmmClass target) {
        Map<String, BmmProperty> propertyMap = source.getProperties();
        propertyMap.values().forEach(property -> this.handleFlattenedProperty((BmmProperty)property, target));
        source.getAncestors().values().forEach(ancestor -> this.populateTarget((BmmClass)ancestor, target));
    }

    protected void handleFlattenedProperty(BmmProperty property, BmmClass target) {
        if (!target.hasPropertyWithName(property.getName()).booleanValue()) {
            target.addProperty(property);
        }
    }

    public BmmClass duplicate() {
        BmmClass target = null;
        target = this instanceof BmmGenericClass ? new BmmGenericClass() : new BmmClass();
        target.setName(this.getName());
        target.getProperties().putAll(this.getProperties());
        target.setAbstract(this.isAbstract);
        target.setSourceSchemaId(this.getSourceSchemaId());
        target.getAncestors().putAll(this.getAncestors());
        target.setImmediateDescendants(this.getImmediateDescendants());
        target.setOverride(this.isOverride);
        target.setPrimitiveType(this.isPrimitiveType);
        target.setPackage(this.getPackage());
        target.setBmmModel(this.getBmmModel());
        return target;
    }

    public Boolean hasPropertyWithName(String propertyName) {
        return this.properties.get(propertyName) != null;
    }

    public String toString() {
        return this.name;
    }
}

