/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.xml.adapters;

import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.xml.adapters.StringDictionaryUtil;
import com.nedap.archie.xml.types.CodeDefinitionSet;
import com.nedap.archie.xml.types.StringDictionaryItem;
import com.nedap.archie.xml.types.TermBindingSet;
import com.nedap.archie.xml.types.XmlArchetypeTerminology;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ArchetypeTerminologyAdapter
extends XmlAdapter<XmlArchetypeTerminology, ArchetypeTerminology> {
    public XmlArchetypeTerminology marshal(ArchetypeTerminology terminology) throws Exception {
        if (terminology == null) {
            return null;
        }
        XmlArchetypeTerminology xmlTerminology = new XmlArchetypeTerminology();
        xmlTerminology.setOriginalLanguage(terminology.getOriginalLanguage());
        xmlTerminology.setDifferential(terminology.getDifferential());
        xmlTerminology.setConceptCode(terminology.getConceptCode());
        xmlTerminology.setTerminologyExtracts(this.convertIntoCodeDefinitionSetList(terminology.getTerminologyExtracts()));
        xmlTerminology.setTermDefinitions(this.convertIntoCodeDefinitionSetList(terminology.getTermDefinitions()));
        xmlTerminology.setTermBindings(this.convertIntoTermBindingSetList(terminology.getTermBindings()));
        xmlTerminology.setValueSets(this.convertIntoValueSetList(terminology.getValueSets()));
        return xmlTerminology;
    }

    private List<ValueSet> convertIntoValueSetList(Map<String, ValueSet> valueSets) {
        return new ArrayList<ValueSet>(valueSets.values());
    }

    private List<TermBindingSet> convertIntoTermBindingSetList(Map<String, Map<String, URI>> map) {
        ArrayList<TermBindingSet> result = new ArrayList<TermBindingSet>();
        for (String id : map.keySet()) {
            Map<String, URI> terms = map.get(id);
            TermBindingSet termBindingSet = new TermBindingSet();
            termBindingSet.setId(id);
            ArrayList<StringDictionaryItem> items = StringDictionaryUtil.convertUriMapIntoStringDictionaryList(terms);
            termBindingSet.setItems(items);
            result.add(termBindingSet);
        }
        return result;
    }

    private List<CodeDefinitionSet> convertIntoCodeDefinitionSetList(Map<String, Map<String, ArchetypeTerm>> map) {
        ArrayList<CodeDefinitionSet> result = new ArrayList<CodeDefinitionSet>();
        for (String language : map.keySet()) {
            Map<String, ArchetypeTerm> terms = map.get(language);
            CodeDefinitionSet codeDefinitionSet = new CodeDefinitionSet();
            codeDefinitionSet.setLanguage(language);
            codeDefinitionSet.setItems(new ArrayList<ArchetypeTerm>(terms.values()));
            result.add(codeDefinitionSet);
        }
        return result;
    }

    public ArchetypeTerminology unmarshal(XmlArchetypeTerminology xmlTerminology) throws Exception {
        if (xmlTerminology == null) {
            return null;
        }
        ArchetypeTerminology terminology = new ArchetypeTerminology();
        terminology.setOriginalLanguage(xmlTerminology.getOriginalLanguage());
        terminology.setDifferential(xmlTerminology.getDifferential());
        terminology.setConceptCode(xmlTerminology.getConceptCode());
        terminology.setTerminologyExtracts(this.convertIntoArchetypeTermMap(xmlTerminology.getTerminologyExtracts()));
        terminology.setTermDefinitions(this.convertIntoArchetypeTermMap(xmlTerminology.getTermDefinitions()));
        terminology.setTermBindings(this.convertIntoTermBindingsMap(xmlTerminology.getTermBindings()));
        terminology.setValueSets(this.convertIntoValueSetMap(xmlTerminology.getValueSets()));
        return terminology;
    }

    private Map<String, ValueSet> convertIntoValueSetMap(List<ValueSet> valueSets) {
        LinkedHashMap<String, ValueSet> result = new LinkedHashMap<String, ValueSet>();
        for (ValueSet valueSet : valueSets) {
            result.put(valueSet.getId(), valueSet);
        }
        return result;
    }

    private Map<String, Map<String, URI>> convertIntoTermBindingsMap(List<TermBindingSet> termBindings) throws Exception {
        LinkedHashMap<String, Map<String, URI>> result = new LinkedHashMap<String, Map<String, URI>>();
        for (TermBindingSet set : termBindings) {
            Map<String, URI> termMap = StringDictionaryUtil.convertStringDictionaryListToUriMap(set.getItems());
            result.put(set.getId(), termMap);
        }
        return result;
    }

    private Map<String, Map<String, ArchetypeTerm>> convertIntoArchetypeTermMap(List<CodeDefinitionSet> list) {
        LinkedHashMap<String, Map<String, ArchetypeTerm>> result = new LinkedHashMap<String, Map<String, ArchetypeTerm>>();
        for (CodeDefinitionSet set : list) {
            LinkedHashMap<String, ArchetypeTerm> termMap = new LinkedHashMap<String, ArchetypeTerm>();
            for (ArchetypeTerm term : set.getItems()) {
                termMap.put(term.getCode(), term);
            }
            result.put(set.getLanguage(), termMap);
        }
        return result;
    }
}

