/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl.constraints;

import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.ADLRulesSerializer;
import com.nedap.archie.serializer.adl.ArchetypeSerializeUtils;
import com.nedap.archie.serializer.adl.constraints.ConstraintSerializer;

public class ArchetypeSlotSerializer
extends ConstraintSerializer<ArchetypeSlot> {
    public ArchetypeSlotSerializer(ADLDefinitionSerializer serializer) {
        super(serializer);
    }

    @Override
    public void serialize(ArchetypeSlot cobj) {
        this.builder.indent().newline();
        this.appendSiblingOrder(cobj);
        this.builder.append("allow_archetype").append(" ").append(cobj.getRmTypeName()).append("[").append(cobj.getNodeId()).append("]");
        if (cobj.getOccurrences() != null) {
            this.builder.append(" occurrences matches {");
            ArchetypeSerializeUtils.buildOccurrences(this.builder, cobj.getOccurrences());
            this.builder.append("}");
        }
        if (cobj.isClosed()) {
            this.builder.append(" closed");
        } else {
            this.appendMatches(cobj);
        }
        this.builder.unindent();
    }

    private void appendMatches(ArchetypeSlot cobj) {
        int mark = this.builder.mark();
        this.builder.append(" matches { ");
        this.builder.lineComment(this.serializer.getTermText(cobj));
        boolean hasContent = false;
        ADLRulesSerializer serializer = new ADLRulesSerializer(this.builder, this.serializer);
        if (cobj.getIncludes() != null && cobj.getIncludes().size() > 0) {
            hasContent = true;
            this.builder.indent().newline().append("include").indent();
            for (Assertion a : cobj.getIncludes()) {
                this.builder.newline();
                serializer.serializeRuleElement(a.getExpression());
            }
            this.builder.unindent().unindent();
        }
        if (cobj.getExcludes() != null && cobj.getExcludes().size() > 0) {
            hasContent = true;
            this.builder.indent().newline().append("exclude").indent();
            for (Assertion a : cobj.getExcludes()) {
                this.builder.newline();
                serializer.serializeRuleElement(a.getExpression());
            }
            this.builder.unindent().unindent();
        }
        if (hasContent) {
            this.builder.clearMark();
            this.builder.newline().append("}");
        } else {
            this.builder.revert(mark);
        }
    }
}

