/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.serializer.adl.ADLStringBuilder;

public class ArchetypeSerializeUtils {
    public static void buildOccurrences(ADLStringBuilder builder, MultiplicityInterval occ) {
        if (occ == null) {
            builder.append("*");
        } else if (occ.isLowerUnbounded() && occ.isUpperUnbounded()) {
            builder.append("*");
        } else if (occ.isLowerUnbounded()) {
            builder.append(0);
            builder.append("..");
            builder.append(ArchetypeSerializeUtils.getUpper(occ));
        } else if (occ.isUpperUnbounded()) {
            builder.append(ArchetypeSerializeUtils.getLower(occ));
            builder.append("..");
            builder.append("*");
        } else if (ArchetypeSerializeUtils.getLowerNumber(occ).equals(ArchetypeSerializeUtils.getUpperNumber(occ))) {
            builder.append(ArchetypeSerializeUtils.getLower(occ));
        } else {
            builder.append(ArchetypeSerializeUtils.getLower(occ));
            builder.append("..");
            builder.append(ArchetypeSerializeUtils.getUpper(occ));
        }
    }

    private static Integer getUpperNumber(MultiplicityInterval occ) {
        if (occ.getUpper() == null) {
            return null;
        }
        if (!occ.isUpperIncluded()) {
            return (Integer)occ.getUpper() - 1;
        }
        return (Integer)occ.getUpper();
    }

    private static Integer getLowerNumber(MultiplicityInterval occ) {
        if (occ.getLower() == null) {
            return 0;
        }
        if (!occ.isLowerIncluded()) {
            return (Integer)occ.getLower() + 1;
        }
        return (Integer)occ.getLower();
    }

    private static String getLower(MultiplicityInterval occ) {
        return Integer.toString(ArchetypeSerializeUtils.getLowerNumber(occ));
    }

    private static String getUpper(MultiplicityInterval occ) {
        if (occ.getUpper() == null) {
            return "*";
        }
        return Integer.toString(ArchetypeSerializeUtils.getUpperNumber(occ));
    }
}

