/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.google.common.base.Joiner;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import com.nedap.archie.serializer.adl.ADLArchetypeSerializer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ADLAuthoredArchetypeSerializer<T extends AuthoredArchetype>
extends ADLArchetypeSerializer<T> {
    public ADLAuthoredArchetypeSerializer(T archetype, Function<String, Archetype> flatArchetypeProvider, RMObjectMapperProvider rmObjectMapperProvider) {
        super(archetype, flatArchetypeProvider, rmObjectMapperProvider);
    }

    @Override
    protected void appendLanguage() {
        if (((AuthoredArchetype)this.archetype).getOriginalLanguage() == null) {
            return;
        }
        this.builder.newline().append("language").newIndentedLine().odin(((AuthoredArchetype)this.archetype).getAuthoredResourceContent()).unindent();
    }

    @Override
    protected void appendDescription() {
        if (((AuthoredArchetype)this.archetype).getDescription() == null) {
            this.builder.newline().append("description");
        } else {
            this.builder.newline().append("description").newIndentedLine().odin(((AuthoredArchetype)this.archetype).getDescription()).unindent();
        }
    }

    @Override
    protected String headTag() {
        return "archetype";
    }

    @Override
    protected void appendHeaderAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (((AuthoredArchetype)this.archetype).getAdlVersion() != null) {
            attributes.put("adl_version", ((AuthoredArchetype)this.archetype).getAdlVersion());
        }
        if (((AuthoredArchetype)this.archetype).getRmRelease() != null) {
            attributes.put("rm_release", ((AuthoredArchetype)this.archetype).getRmRelease());
        }
        if (Boolean.TRUE.equals(((AuthoredArchetype)this.archetype).getGenerated())) {
            attributes.put("generated", null);
        }
        if (((AuthoredArchetype)this.archetype).getUid() != null) {
            attributes.put("uid", ((AuthoredArchetype)this.archetype).getUid());
        }
        if (((AuthoredArchetype)this.archetype).getBuildUid() != null) {
            attributes.put("build_uid", ((AuthoredArchetype)this.archetype).getBuildUid());
        }
        if (!attributes.isEmpty()) {
            List elements = attributes.entrySet().stream().map(e -> {
                if (e.getValue() == null) {
                    return (String)e.getKey();
                }
                return (String)e.getKey() + "=" + (String)e.getValue();
            }).collect(Collectors.toList());
            this.builder.append(" (").append(Joiner.on((String)"; ").join(elements)).append(")");
        }
    }
}

