/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import com.nedap.archie.rminfo.RMPackageId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReferenceModels {
    private Map<RMPackageId, ModelInfoLookup> referenceModelsById = new ConcurrentHashMap<RMPackageId, ModelInfoLookup>();
    private Map<RMPackageId, RMObjectMapperProvider> objectMapperProvidersById = new ConcurrentHashMap<RMPackageId, RMObjectMapperProvider>();

    public ReferenceModels() {
    }

    public ReferenceModels(ModelInfoLookup ... models) {
        for (ModelInfoLookup model : models) {
            this.registerModel(model);
        }
    }

    public void registerModel(ModelInfoLookup model) {
        this.registerModel(model, null);
    }

    public void registerModel(ModelInfoLookup model, RMObjectMapperProvider rmObjectMapperProvider) {
        for (RMPackageId id : model.getId()) {
            this.referenceModelsById.put(id, model);
            if (rmObjectMapperProvider == null) continue;
            this.objectMapperProvidersById.put(id, rmObjectMapperProvider);
        }
    }

    public ModelInfoLookup getModel(String publisher, String aPackage) {
        return this.referenceModelsById.get(new RMPackageId(publisher, aPackage));
    }

    public ModelInfoLookup getModel(Archetype archetype) {
        return this.getModel(archetype.getArchetypeId().getRmPublisher(), archetype.getArchetypeId().getRmPackage());
    }

    public RMObjectMapperProvider getRmObjectMapperProvider(String publisher, String aPackage) {
        return this.objectMapperProvidersById.get(new RMPackageId(publisher, aPackage));
    }

    public RMObjectMapperProvider getRmObjectMapperProvider(Archetype archetype) {
        return this.getRmObjectMapperProvider(archetype.getArchetypeId().getRmPublisher(), archetype.getArchetypeId().getRmPackage());
    }

    public List<ModelInfoLookup> getAllModels() {
        return new ArrayList<ModelInfoLookup>(this.referenceModelsById.values());
    }
}

