/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.rminfo.ModelNamingStrategy;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMPackageId;
import com.nedap.archie.rminfo.RMTypeInfo;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ModelInfoLookup {
    public Class getClass(String var1);

    public Class getClassToBeCreated(String var1);

    public Map<String, Class> getRmTypeNameToClassMap();

    public RMTypeInfo getTypeInfo(Class var1);

    public Field getField(Class var1, String var2);

    public RMTypeInfo getTypeInfo(String var1);

    public RMAttributeInfo getAttributeInfo(Class var1, String var2);

    public RMAttributeInfo getAttributeInfo(String var1, String var2);

    public List<RMTypeInfo> getAllTypes();

    public ModelNamingStrategy getNamingStrategy();

    public Object convertToConstraintObject(Object var1, CPrimitiveObject var2);

    public Object convertConstrainedPrimitiveToRMObject(Object var1);

    public void processCreatedObject(Object var1, CObject var2);

    public String getArchetypeNodeIdFromRMObject(Object var1);

    public String getArchetypeIdFromArchetypedRmObject(Object var1);

    public String getNameFromRMObject(Object var1);

    public Object clone(Object var1);

    public Map<String, Object> pathHasBeenUpdated(Object var1, Archetype var2, String var3, Object var4);

    public boolean validatePrimitiveType(String var1, String var2, CPrimitiveObject var3);

    public Collection<RMPackageId> getId();

    default public MultiplicityInterval referenceModelPropMultiplicity(String rmTypeName, String rmAttributeNameOrPath) {
        RMAttributeInfo attributeInfo;
        RMTypeInfo typeInfo = this.getTypeInfo(rmTypeName);
        String rmAttributeName = rmAttributeNameOrPath;
        if (rmAttributeNameOrPath.contains("[") || rmAttributeNameOrPath.contains("/")) {
            APathQuery aPathQuery = new APathQuery(rmAttributeNameOrPath);
            for (int i = 0; i < aPathQuery.getPathSegments().size() - 1; ++i) {
                PathSegment segment = (PathSegment)aPathQuery.getPathSegments().get(i);
                RMAttributeInfo attributeInfo2 = typeInfo.getAttribute(segment.getNodeName());
                typeInfo = this.getTypeInfo(attributeInfo2.getTypeNameInCollection());
            }
            rmAttributeName = ((PathSegment)aPathQuery.getPathSegments().get(aPathQuery.getPathSegments().size() - 1)).getNodeName();
        }
        if ((attributeInfo = typeInfo.getAttribute(rmAttributeName)).isMultipleValued()) {
            return MultiplicityInterval.createUpperUnbounded((Integer)0);
        }
        if (attributeInfo.isNullable()) {
            return MultiplicityInterval.createBounded((int)0, (int)1);
        }
        return MultiplicityInterval.createBounded((int)1, (int)1);
    }

    default public Boolean rmTypesConformant(String childType, String parentType) {
        RMTypeInfo parentTypeInfo = this.getTypeInfo(parentType);
        RMTypeInfo childTypeInfo = this.getTypeInfo(childType);
        if (childTypeInfo == null || parentTypeInfo == null) {
            return true;
        }
        return childTypeInfo.isDescendantOrEqual(parentTypeInfo);
    }
}

