/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.nedap.archie.rminfo.ModelNamingStrategy;
import com.nedap.archie.rminfo.RMProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ArchieModelNamingStrategy
implements ModelNamingStrategy {
    public static final PropertyNamingStrategy.SnakeCaseStrategy snakeCaseStrategy = new PropertyNamingStrategy.SnakeCaseStrategy();

    public String getTypeName(Class clazz) {
        String name;
        switch (name = clazz.getSimpleName()) {
            case "DvEHRURI": {
                return "DV_EHR_URI";
            }
            case "UIDBasedId": {
                return "UID_BASED_ID";
            }
        }
        String result = snakeCaseStrategy.translate(clazz.getSimpleName()).toUpperCase();
        if (name.length() > 1 && name.startsWith("C") && Character.isUpperCase(name.charAt(1))) {
            result = result.replaceFirst("C", "C_");
        }
        return result;
    }

    public String getAttributeName(Field field, Method method) {
        RMProperty annotation;
        if (field != null && (annotation = field.getDeclaredAnnotation(RMProperty.class)) != null) {
            return annotation.value();
        }
        if (method != null && (annotation = method.getDeclaredAnnotation(RMProperty.class)) != null) {
            return annotation.value();
        }
        if (field != null) {
            return snakeCaseStrategy.translate(field.getName());
        }
        if (method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("add")) {
            return snakeCaseStrategy.translate(method.getName().substring(3)).toLowerCase();
        }
        if (method.getName().startsWith("is")) {
            if (method.getName().equalsIgnoreCase("isIntegral")) {
                return "is_integral";
            }
            return snakeCaseStrategy.translate(method.getName().substring(2)).toLowerCase();
        }
        return method.getName();
    }
}

