/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.query.AOMPathQuery;
import java.util.List;

public class ComplexObjectProxyReplacement {
    private final CComplexObject replacement;
    private final CComplexObjectProxy proxy;

    public ComplexObjectProxyReplacement(CComplexObjectProxy proxy, CComplexObject replacement) {
        this.proxy = proxy;
        this.replacement = replacement;
    }

    public void replace() {
        this.proxy.getParent().replaceChild(this.proxy.getNodeId(), this.replacement);
    }

    public static ComplexObjectProxyReplacement getComplexObjectProxyReplacement(CComplexObjectProxy proxy) {
        List newObjects = new AOMPathQuery(proxy.getTargetPath()).findList(ComplexObjectProxyReplacement.getNearestArchetypeRoot(proxy), true);
        if (newObjects == null || newObjects.isEmpty()) {
            return null;
        }
        CObject found = (CObject)newObjects.get(0);
        CComplexObject clone = (CComplexObject)found.clone();
        clone.setNodeId(proxy.getNodeId());
        if (proxy.getOccurrences() != null) {
            clone.setOccurrences(proxy.getOccurrences());
        }
        if (proxy.getSiblingOrder() != null) {
            clone.setSiblingOrder(proxy.getSiblingOrder());
        }
        return new ComplexObjectProxyReplacement(proxy, clone);
    }

    public static CComplexObject getNearestArchetypeRoot(CObject object) {
        CObject parentObject;
        CAttribute parentAttribute = object.getParent();
        while (parentAttribute != null && (parentObject = parentAttribute.getParent()) != null) {
            if (parentObject instanceof CArchetypeRoot) {
                return (CArchetypeRoot)parentObject;
            }
            parentAttribute = parentObject.getParent();
        }
        return object.getArchetype().getDefinition();
    }

    public CComplexObject getReplacement() {
        return this.replacement;
    }
}

