/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.terminology;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ARCHETYPE_TERMINOLOGY_TEST")
public class ArchetypeTerminology
extends ArchetypeModelObject {
    private Boolean differential;
    @XmlElement(name="original_language")
    private String originalLanguage;
    @XmlElement(name="concept_code")
    private String conceptCode;
    @XmlTransient
    private Map<String, Map<String, ArchetypeTerm>> termDefinitions = new ConcurrentHashMap<String, Map<String, ArchetypeTerm>>();
    @XmlTransient
    private Map<String, Map<String, URI>> termBindings = new ConcurrentHashMap<String, Map<String, URI>>();
    @XmlTransient
    private Map<String, Map<String, ArchetypeTerm>> terminologyExtracts = new ConcurrentHashMap<String, Map<String, ArchetypeTerm>>();
    @XmlElement(name="value_sets")
    private Map<String, ValueSet> valueSets = new ConcurrentHashMap<String, ValueSet>();
    @JsonIgnore
    private transient Archetype ownerArchetype;

    public Boolean getDifferential() {
        return this.differential;
    }

    public void setDifferential(Boolean differential) {
        this.differential = differential;
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = originalLanguage;
    }

    public String getConceptCode() {
        return this.conceptCode;
    }

    public void setConceptCode(String conceptCode) {
        this.conceptCode = conceptCode;
    }

    public Map<String, Map<String, ArchetypeTerm>> getTermDefinitions() {
        return this.termDefinitions;
    }

    public void setTermDefinitions(Map<String, Map<String, ArchetypeTerm>> termDefinitions) {
        this.termDefinitions = termDefinitions;
    }

    public Map<String, Map<String, URI>> getTermBindings() {
        return this.termBindings;
    }

    public void setTermBindings(Map<String, Map<String, URI>> termBindings) {
        this.termBindings = termBindings;
    }

    public Map<String, Map<String, ArchetypeTerm>> getTerminologyExtracts() {
        return this.terminologyExtracts;
    }

    public void setTerminologyExtracts(Map<String, Map<String, ArchetypeTerm>> terminologyExtracts) {
        this.terminologyExtracts = terminologyExtracts;
    }

    public Archetype getOwnerArchetype() {
        return this.ownerArchetype;
    }

    public void setOwnerArchetype(Archetype ownerArchetype) {
        this.ownerArchetype = ownerArchetype;
    }

    public Map<String, ValueSet> getValueSets() {
        return this.valueSets;
    }

    public void setValueSets(Map<String, ValueSet> valueSets) {
        this.valueSets = valueSets;
    }

    public ArchetypeTerm getTermDefinition(String language, String code) {
        Map<String, ArchetypeTerm> translated = this.termDefinitions.get(language);
        if (translated == null) {
            return null;
        }
        return translated.get(code);
    }

    public URI getTermBinding(String terminologyId, String code) {
        Map<String, URI> translated = this.termBindings.get(terminologyId);
        if (translated == null) {
            return null;
        }
        return translated.get(code);
    }

    public Integer specialisationDepth() {
        return AOMUtils.getSpecializationDepthFromCode(this.conceptCode);
    }

    public List<String> idCodes() {
        HashSet<String> codes = new HashSet<String>();
        for (String language : this.getTermDefinitions().keySet()) {
            for (String code : this.getTermDefinitions().get(language).keySet()) {
                if (!AOMUtils.isIdCode(code)) continue;
                codes.add(code);
            }
        }
        return new ArrayList<String>(codes);
    }

    public List<String> valueCodes() {
        HashSet<String> codes = new HashSet<String>();
        for (String language : this.getTermDefinitions().keySet()) {
            for (String code : this.getTermDefinitions().get(language).keySet()) {
                if (!AOMUtils.isValueCode(code)) continue;
                codes.add(code);
            }
        }
        return new ArrayList<String>(codes);
    }

    public List<String> valueSetCodes() {
        HashSet<String> codes = new HashSet<String>();
        for (String language : this.getTermDefinitions().keySet()) {
            for (String code : this.getTermDefinitions().get(language).keySet()) {
                if (!AOMUtils.isValueSetCode(code)) continue;
                codes.add(code);
            }
        }
        return new ArrayList<String>(codes);
    }

    public List<String> allCodes() {
        HashSet<String> codes = new HashSet<String>();
        for (String language : this.getTermDefinitions().keySet()) {
            for (String code : this.getTermDefinitions().get(language).keySet()) {
                codes.add(code);
            }
        }
        return new ArrayList<String>(codes);
    }

    public boolean hasCode(String code) {
        if (this.termDefinitions == null) {
            return false;
        }
        if (this.originalLanguage == null) {
            for (String language : this.getTermDefinitions().keySet()) {
                if (!this.getTermDefinitions().get(language).containsKey(code)) continue;
                return true;
            }
            return false;
        }
        Map<String, ArchetypeTerm> termDefinitionsForLanguage = this.getTermDefinitions().get(this.originalLanguage);
        return termDefinitionsForLanguage != null && termDefinitionsForLanguage.containsKey(code);
    }

    public boolean hasIdCode(String code) {
        return AOMUtils.isIdCode(code) && this.hasCode(code);
    }

    public boolean hasCodeInAllLanguages(String code) {
        if (this.termDefinitions == null) {
            return false;
        }
        for (String language : this.getTermDefinitions().keySet()) {
            if (this.getTermDefinitions().get(language).containsKey(code)) continue;
            return false;
        }
        return true;
    }

    public boolean hasIdCodeInAllLanguages(String code) {
        return AOMUtils.isIdCode(code) && this.hasCodeInAllLanguages(code);
    }

    public boolean hasValueSetCode(String code) {
        return AOMUtils.isValueSetCode(code) && this.hasCode(code);
    }

    public boolean hasValueCode(String code) {
        return AOMUtils.isValueCode(code) && this.hasCode(code);
    }
}

