/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.google.common.collect.Lists;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="C_STRING")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CString
extends CPrimitiveObject<String, String> {
    @XmlElement(name="assumed_value")
    private String assumedValue;
    private List<String> constraint = new ArrayList<String>();

    public CString() {
    }

    public CString(String constraint) {
        this.constraint = Lists.newArrayList((Object[])new String[]{constraint});
    }

    @Override
    public String getAssumedValue() {
        return this.assumedValue;
    }

    @Override
    public void setAssumedValue(String assumedValue) {
        this.assumedValue = assumedValue;
    }

    @Override
    public List<String> getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(List<String> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addConstraint(String constraint) {
        this.constraint.add(constraint);
    }

    @Override
    public boolean isValidValue(String value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        for (String constraint : this.getConstraint()) {
            if (!(constraint.length() > 1 && CString.isRegexConstraint(constraint) ? this.matchesRegexp(value, constraint) : Objects.equals(value, constraint))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesRegexp(String value, String constraint) {
        return value.matches(constraint.substring(1).substring(0, constraint.length() - 2));
    }

    public static boolean isRegexConstraint(String constraint) {
        return constraint.startsWith("/") && constraint.endsWith("/") || constraint.startsWith("^") && constraint.endsWith("^");
    }

    @Override
    public boolean cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (!super.cConformsTo(other, rmTypesConformant)) {
            return false;
        }
        CString otherString = (CString)other;
        if (otherString.constraint.isEmpty()) {
            return true;
        }
        for (String constraint : this.constraint) {
            if (this.hasMatchingConstraint(constraint, otherString)) continue;
            return false;
        }
        return true;
    }

    private boolean hasMatchingConstraint(String constraint, CString otherString) {
        boolean isRegexp = CString.isRegexConstraint(constraint);
        for (String otherConstraint : otherString.constraint) {
            boolean otherIsRegexp = CString.isRegexConstraint(otherConstraint);
            if (!(otherIsRegexp && !isRegexp ? this.matchesRegexp(constraint, otherConstraint) : otherConstraint.equals(constraint))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CString cString = (CString)o;
        return Objects.equals(this.assumedValue, cString.assumedValue) && Objects.equals(this.constraint, cString.constraint);
    }

    public int hashCode() {
        return Objects.hash(this.assumedValue, this.constraint);
    }
}

