/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.antlr.ContainedRegexLexer;
import com.nedap.archie.adlparser.antlr.ContainedRegexParser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.adlparser.treewalkers.NumberConstraintParser;
import com.nedap.archie.adlparser.treewalkers.TemporalConstraintParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.serializer.odin.OdinValueParser;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PrimitivesConstraintParser
extends BaseTreeWalker {
    private final NumberConstraintParser numberConstraintParser;
    private final TemporalConstraintParser temporalConstraintParser;

    public PrimitivesConstraintParser(ANTLRParserErrors errors) {
        super(errors);
        this.numberConstraintParser = new NumberConstraintParser(errors);
        this.temporalConstraintParser = new TemporalConstraintParser(errors);
    }

    public CPrimitiveObject parsePrimitiveObject(AdlParser.C_primitive_objectContext objectContext) {
        if (objectContext.c_integer() != null) {
            return this.numberConstraintParser.parseCInteger(objectContext.c_integer());
        }
        if (objectContext.c_real() != null) {
            return this.numberConstraintParser.parseCReal(objectContext.c_real());
        }
        if (objectContext.c_date() != null) {
            return this.parseCDate(objectContext.c_date());
        }
        if (objectContext.c_time() != null) {
            return this.parseCTime(objectContext.c_time());
        }
        if (objectContext.c_date_time() != null) {
            return this.parseCDateTime(objectContext.c_date_time());
        }
        if (objectContext.c_duration() != null) {
            return this.parseCDuration(objectContext.c_duration());
        }
        if (objectContext.c_string() != null) {
            return this.parseCString(objectContext.c_string());
        }
        if (objectContext.c_terminology_code() != null) {
            return this.parseCTerminologyCode(objectContext.c_terminology_code());
        }
        if (objectContext.c_boolean() != null) {
            return this.parseCBoolean(objectContext.c_boolean());
        }
        return null;
    }

    public CBoolean parseCBoolean(AdlParser.C_booleanContext booleanContext) {
        AdlParser.Boolean_valueContext booleanValueContext;
        AdlParser.Boolean_list_valueContext booleanListValue;
        CBoolean result = new CBoolean();
        if (booleanContext.assumed_boolean_value() != null) {
            result.setAssumedValue(this.parseBoolean(booleanContext.assumed_boolean_value().boolean_value()));
        }
        if ((booleanListValue = booleanContext.boolean_list_value()) != null) {
            this.parseBooleanValues(result, booleanListValue.boolean_value());
        }
        if ((booleanValueContext = booleanContext.boolean_value()) != null) {
            result.addConstraint(this.parseBoolean(booleanValueContext));
        }
        return result;
    }

    private boolean parseBoolean(AdlParser.Boolean_valueContext context) {
        return context.SYM_FALSE() == null;
    }

    private void parseBooleanValues(CBoolean result, List<AdlParser.Boolean_valueContext> booleanValues) {
        for (AdlParser.Boolean_valueContext booleanValue : booleanValues) {
            result.addConstraint(this.parseBoolean(booleanValue));
        }
    }

    public CTerminologyCode parseCTerminologyCode(AdlParser.C_terminology_codeContext terminologyCodeContext) {
        boolean containsAssumedValue;
        CTerminologyCode result = new CTerminologyCode();
        boolean bl = containsAssumedValue = !terminologyCodeContext.getTokens(93).isEmpty();
        if (containsAssumedValue) {
            String terminologyId = terminologyCodeContext.AC_CODE().getText();
            TerminologyCode assumedValue = new TerminologyCode();
            assumedValue.setTerminologyId(terminologyId);
            String assumedValueString = terminologyCodeContext.AT_CODE().getText();
            assumedValue.setCodeString(assumedValueString);
            result.setAssumedValue(assumedValue);
            result.addConstraint(assumedValue.getTerminologyIdString());
        } else if (terminologyCodeContext.AC_CODE() != null) {
            result.addConstraint(terminologyCodeContext.AC_CODE().getText());
        } else {
            result.addConstraint(terminologyCodeContext.AT_CODE().getText());
        }
        return result;
    }

    public CString parseCString(AdlParser.C_stringContext stringContext) {
        CString result = new CString();
        if (stringContext.assumed_string_value() != null) {
            result.setAssumedValue(OdinValueParser.parseOdinStringValue((AdlParser.String_valueContext)stringContext.assumed_string_value().string_value()));
        }
        AdlParser.String_valueContext stringValueContext = stringContext.string_value();
        AdlParser.String_list_valueContext stringListValueContext = stringContext.string_list_value();
        if (stringListValueContext != null) {
            for (AdlParser.String_valueContext string : stringListValueContext.string_value()) {
                result.addConstraint(OdinValueParser.parseOdinStringValue((AdlParser.String_valueContext)string));
            }
        }
        if (stringValueContext != null) {
            result.addConstraint(OdinValueParser.parseOdinStringValue((AdlParser.String_valueContext)stringValueContext));
        }
        return result;
    }

    public CDuration parseCDuration(AdlParser.C_durationContext context) {
        return this.temporalConstraintParser.parseCDuration(context);
    }

    public CDateTime parseCDateTime(AdlParser.C_date_timeContext context) {
        return this.temporalConstraintParser.parseCDateTime(context);
    }

    public CTime parseCTime(AdlParser.C_timeContext context) {
        return this.temporalConstraintParser.parseCTime(context);
    }

    public CDate parseCDate(AdlParser.C_dateContext context) {
        return this.temporalConstraintParser.parseCDate(context);
    }

    public CPrimitiveObject parseRegex(TerminalNode terminalNode) {
        ContainedRegexLexer lexer = new ContainedRegexLexer((CharStream)CharStreams.fromString((String)terminalNode.getText()));
        ContainedRegexParser parser = new ContainedRegexParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ContainedRegexParser.RegexContext regex = parser.regex();
        CString result = new CString();
        result.addConstraint(regex.REGEX().getText());
        if (regex.STRING() != null) {
            String assumedValue = regex.STRING().getText();
            result.setAssumedValue(assumedValue.substring(1, assumedValue.length() - 1));
        }
        return result;
    }
}

