/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.modelconstraints;

import com.google.common.collect.Sets;
import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import java.util.Set;
import org.openehr.bmm.core.BmmContainerProperty;
import org.openehr.bmm.core.BmmContainerType;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmProperty;

public class BMMConstraintImposer
implements ModelConstraintImposer {
    private final BmmModel model;
    private Set<String> nonOrderedContainerTypes = Sets.newHashSet((Object[])new String[]{"set", "hash", "bag"});
    private Set<String> uniqueContainerTypes = Sets.newHashSet((Object[])new String[]{"set", "hash"});

    public BMMConstraintImposer(BmmModel model) {
        this.model = model;
    }

    @Override
    public CAttribute getDefaultAttribute(String typeId, String attribute) {
        BmmProperty property = this.model.propertyAtPath(typeId, attribute);
        if (property == null) {
            return null;
        }
        CAttribute result = new CAttribute();
        MultiplicityInterval existence = property.getExistence();
        result.setExistence(existence);
        if (property instanceof BmmContainerProperty) {
            BmmContainerProperty containerProperty = (BmmContainerProperty)property;
            Cardinality cardinality = new Cardinality();
            cardinality.setInterval(containerProperty.getCardinality());
            String name = ((BmmContainerType)containerProperty.getType()).getContainerType().getName();
            cardinality.setOrdered(!this.nonOrderedContainerTypes.contains(name.toLowerCase()));
            cardinality.setUnique(this.uniqueContainerTypes.contains(name.toLowerCase()));
            result.setCardinality(cardinality);
            result.setMultiple(true);
        } else {
            result.setMultiple(false);
        }
        return result;
    }
}

