/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14.treewalkers;

import com.nedap.archie.adl14.treewalkers.Adl14NumberConstraintParser;
import com.nedap.archie.adl14.treewalkers.Adl14TemporalConstraintParser;
import com.nedap.archie.adl14.treewalkers.Odin14ValueParser;
import com.nedap.archie.adlparser.antlr.Adl14Parser;
import com.nedap.archie.adlparser.antlr.ContainedRegexLexer;
import com.nedap.archie.adlparser.antlr.ContainedRegexParser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CBoolean;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.base.terminology.TerminologyCode;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;

public class Adl14PrimitivesConstraintParser
extends BaseTreeWalker {
    private final Adl14NumberConstraintParser numberConstraintParser;
    private final Adl14TemporalConstraintParser temporalConstraintParser;

    public Adl14PrimitivesConstraintParser(ANTLRParserErrors errors) {
        super(errors);
        this.numberConstraintParser = new Adl14NumberConstraintParser(errors);
        this.temporalConstraintParser = new Adl14TemporalConstraintParser(errors);
    }

    public CPrimitiveObject parsePrimitiveObject(Adl14Parser.C_primitive_objectContext objectContext) {
        if (objectContext.c_integer() != null) {
            return this.numberConstraintParser.parseCInteger(objectContext.c_integer());
        }
        if (objectContext.c_real() != null) {
            return this.numberConstraintParser.parseCReal(objectContext.c_real());
        }
        if (objectContext.c_date() != null) {
            return this.parseCDate(objectContext.c_date());
        }
        if (objectContext.c_time() != null) {
            return this.parseCTime(objectContext.c_time());
        }
        if (objectContext.c_date_time() != null) {
            return this.parseCDateTime(objectContext.c_date_time());
        }
        if (objectContext.c_duration() != null) {
            return this.parseCDuration(objectContext.c_duration());
        }
        if (objectContext.c_string() != null) {
            return this.parseCString(objectContext.c_string());
        }
        if (objectContext.c_terminology_code() != null) {
            return this.parseCTerminologyCode(objectContext.c_terminology_code());
        }
        if (objectContext.c_boolean() != null) {
            return this.parseCBoolean(objectContext.c_boolean());
        }
        throw new IllegalArgumentException("unknown primitive: " + objectContext.getText());
    }

    public CBoolean parseCBoolean(Adl14Parser.C_booleanContext booleanContext) {
        Adl14Parser.Boolean_valueContext booleanValueContext;
        Adl14Parser.Boolean_list_valueContext booleanListValue;
        CBoolean result = new CBoolean();
        if (booleanContext.assumed_boolean_value() != null) {
            result.setAssumedValue(this.parseBoolean(booleanContext.assumed_boolean_value().boolean_value()));
        }
        if ((booleanListValue = booleanContext.boolean_list_value()) != null) {
            this.parseBooleanValues(result, booleanListValue.boolean_value());
        }
        if ((booleanValueContext = booleanContext.boolean_value()) != null) {
            result.addConstraint(this.parseBoolean(booleanValueContext));
        }
        return result;
    }

    private boolean parseBoolean(Adl14Parser.Boolean_valueContext context) {
        return context.SYM_FALSE() == null;
    }

    private void parseBooleanValues(CBoolean result, List<Adl14Parser.Boolean_valueContext> booleanValues) {
        for (Adl14Parser.Boolean_valueContext booleanValue : booleanValues) {
            result.addConstraint(this.parseBoolean(booleanValue));
        }
    }

    public CTerminologyCode parseCTerminologyCode(Adl14Parser.C_terminology_codeContext terminologyCodeContext) {
        CTerminologyCode result = new CTerminologyCode();
        boolean containsAssumedValue = !terminologyCodeContext.getTokens(94).isEmpty();
        Adl14Parser.QualifiedTermCodeContext qualifiedTermCodeContext = terminologyCodeContext.qualifiedTermCode();
        if (qualifiedTermCodeContext != null) {
            if (qualifiedTermCodeContext.TERM_CODE_REF() != null) {
                TerminologyCode terminologyCode = TerminologyCode.createFromString((String)qualifiedTermCodeContext.TERM_CODE_REF().getText());
                if (terminologyCode.getTerminologyId() != null && terminologyCode.getTerminologyId().equalsIgnoreCase("local")) {
                    result.addConstraint(terminologyCode.getCodeString());
                } else {
                    result.addConstraint(qualifiedTermCodeContext.TERM_CODE_REF().getText());
                }
            } else {
                String terminologyId = qualifiedTermCodeContext.identifier(0).getText();
                if (terminologyId.equalsIgnoreCase("local")) {
                    for (int i = 1; i < qualifiedTermCodeContext.identifier().size(); ++i) {
                        result.addConstraint(qualifiedTermCodeContext.identifier(i).getText());
                    }
                } else {
                    for (int i = 0; i < qualifiedTermCodeContext.identifier().size(); ++i) {
                        result.addConstraint(qualifiedTermCodeContext.identifier(i).getText());
                    }
                }
            }
            if (qualifiedTermCodeContext.assumed_value() != null) {
                result.setAssumedValue(TerminologyCode.createFromString((String)qualifiedTermCodeContext.assumed_value().getText()));
            }
        } else {
            if (terminologyCodeContext.localTermCode().AC_CODE() == null) {
                throw new RuntimeException("unknown terminology code format - this looks adl2 inside the adl 1.4 format?");
            }
            result.addConstraint(terminologyCodeContext.localTermCode().AC_CODE().getText());
            if (containsAssumedValue) {
                result.setAssumedValue(TerminologyCode.createFromString((String)terminologyCodeContext.localTermCode().AT_CODE().getText()));
            }
        }
        return result;
    }

    public CString parseCString(Adl14Parser.C_stringContext stringContext) {
        CString result = new CString();
        if (stringContext.assumed_string_value() != null) {
            result.setAssumedValue(Odin14ValueParser.parseOdinStringValue(stringContext.assumed_string_value().string_value()));
        }
        Adl14Parser.String_valueContext stringValueContext = stringContext.string_value();
        Adl14Parser.String_list_valueContext stringListValueContext = stringContext.string_list_value();
        if (stringListValueContext != null) {
            for (Adl14Parser.String_valueContext string : stringListValueContext.string_value()) {
                result.addConstraint(Odin14ValueParser.parseOdinStringValue(string));
            }
        }
        if (stringValueContext != null) {
            result.addConstraint(Odin14ValueParser.parseOdinStringValue(stringValueContext));
        }
        return result;
    }

    public CDuration parseCDuration(Adl14Parser.C_durationContext context) {
        return this.temporalConstraintParser.parseCDuration(context);
    }

    public CDateTime parseCDateTime(Adl14Parser.C_date_timeContext context) {
        return this.temporalConstraintParser.parseCDateTime(context);
    }

    public CTime parseCTime(Adl14Parser.C_timeContext context) {
        return this.temporalConstraintParser.parseCTime(context);
    }

    public CDate parseCDate(Adl14Parser.C_dateContext context) {
        return this.temporalConstraintParser.parseCDate(context);
    }

    public CPrimitiveObject parseRegex(TerminalNode terminalNode) {
        ContainedRegexLexer lexer = new ContainedRegexLexer((CharStream)CharStreams.fromString((String)terminalNode.getText()));
        ContainedRegexParser parser = new ContainedRegexParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ContainedRegexParser.RegexContext regex = parser.regex();
        CString result = new CString();
        result.addConstraint(regex.REGEX().getText());
        if (regex.STRING() != null) {
            String assumedValue = regex.STRING().getText();
            result.setAssumedValue(assumedValue.substring(1, assumedValue.length() - 1));
        }
        return result;
    }
}

